/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import org.springframework.data.elasticsearch.core.query.FetchSourceFilter;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;

public class FetchSourceFilterBuilder {
    @Nullable
    private Boolean fetchSource;
    @Nullable
    private String[] includes;
    @Nullable
    private String[] excludes;

    public FetchSourceFilterBuilder withIncludes(String ... includes) {
        this.includes = includes;
        return this;
    }

    public FetchSourceFilterBuilder withExcludes(String ... excludes) {
        this.excludes = excludes;
        return this;
    }

    public FetchSourceFilterBuilder withFetchSource(Boolean fetchSource) {
        this.fetchSource = fetchSource;
        return this;
    }

    public SourceFilter build() {
        if (this.includes == null) {
            this.includes = new String[0];
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        return new FetchSourceFilter(this.fetchSource, this.includes, this.excludes);
    }
}

