/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support.spel;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.support.value.ElasticsearchQueryValueConversionService;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.common.CompositeStringExpression;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class QueryStringSpELEvaluator {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final Map<String, Expression> QUERY_EXPRESSIONS = new ConcurrentHashMap<String, Expression>();
    private final String queryString;
    private final ElasticsearchParametersParameterAccessor parameterAccessor;
    private final QueryMethod queryMethod;
    private final ValueEvaluationContextProvider evaluationContextProvider;
    private final TypeConverter elasticsearchSpELTypeConverter;

    public QueryStringSpELEvaluator(String queryString, ElasticsearchParametersParameterAccessor parameterAccessor, QueryMethod queryMethod, ValueEvaluationContextProvider evaluationContextProvider, ConversionService conversionService) {
        Assert.notNull((Object)queryString, (String)"queryString must not be null");
        Assert.notNull((Object)parameterAccessor, (String)"parameterAccessor must not be null");
        Assert.notNull((Object)queryMethod, (String)"queryMethod must not be null");
        Assert.notNull((Object)evaluationContextProvider, (String)"evaluationContextProvider must not be null");
        Assert.notNull((Object)conversionService, (String)"conversionService must not be null");
        this.queryString = queryString;
        this.parameterAccessor = parameterAccessor;
        this.queryMethod = queryMethod;
        this.evaluationContextProvider = evaluationContextProvider;
        this.elasticsearchSpELTypeConverter = new StandardTypeConverter((ConversionService)ElasticsearchQueryValueConversionService.getInstance(conversionService));
    }

    public String evaluate() {
        Expression expr = this.getQueryExpression(this.queryString);
        if (expr != null) {
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext((Object)this.parameterAccessor.getValues()).getRequiredEvaluationContext();
            if (context instanceof StandardEvaluationContext) {
                StandardEvaluationContext standardEvaluationContext = (StandardEvaluationContext)context;
                standardEvaluationContext.setTypeConverter(this.elasticsearchSpELTypeConverter);
            }
            String parsed = this.parseExpressions(expr, context);
            Assert.notNull((Object)parsed, (String)"Query parsed by SpEL should not be null");
            return parsed;
        }
        return this.queryString;
    }

    private String parseExpressions(Expression rootExpr, EvaluationContext context) {
        StringBuilder parsed = new StringBuilder();
        if (rootExpr instanceof LiteralExpression) {
            LiteralExpression literalExpression = (LiteralExpression)rootExpr;
            parsed.append(literalExpression.getExpressionString());
        } else if (rootExpr instanceof SpelExpression) {
            SpelExpression spelExpression = (SpelExpression)rootExpr;
            String value = (String)spelExpression.getValue(context, String.class);
            if (value == null) {
                throw new ConversionException(String.format("Parameter value can't be null for SpEL expression '%s' in method '%s' when querying elasticsearch", spelExpression.getExpressionString(), this.queryMethod.getName()));
            }
            parsed.append(value);
        } else if (rootExpr instanceof CompositeStringExpression) {
            Expression[] expressions;
            CompositeStringExpression compositeStringExpression = (CompositeStringExpression)rootExpr;
            for (Expression exp : expressions = compositeStringExpression.getExpressions()) {
                parsed.append(this.parseExpressions(exp, context));
            }
        } else {
            parsed.append((String)rootExpr.getValue(context, String.class));
        }
        return parsed.toString();
    }

    @Nullable
    private Expression getQueryExpression(String queryString) {
        return QUERY_EXPRESSIONS.computeIfAbsent(queryString, f -> {
            Expression expr = PARSER.parseExpression(queryString, ParserContext.TEMPLATE_EXPRESSION);
            return expr instanceof LiteralExpression ? null : expr;
        });
    }
}

