/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.Collections;
import java.util.List;
import org.springframework.data.elasticsearch.core.AggregationsContainer;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchHitsImpl<T>
implements SearchScrollHits<T> {
    private final long totalHits;
    private final TotalHitsRelation totalHitsRelation;
    private final float maxScore;
    @Nullable
    private final String scrollId;
    private final List<? extends SearchHit<T>> searchHits;
    private final Lazy<List<SearchHit<T>>> unmodifiableSearchHits;
    @Nullable
    private final AggregationsContainer<?> aggregations;
    @Nullable
    private final Suggest suggest;
    @Nullable
    private String pointInTimeId;

    public SearchHitsImpl(long totalHits, TotalHitsRelation totalHitsRelation, float maxScore, @Nullable String scrollId, @Nullable String pointInTimeId, List<? extends SearchHit<T>> searchHits, @Nullable AggregationsContainer<?> aggregations, @Nullable Suggest suggest) {
        Assert.notNull(searchHits, (String)"searchHits must not be null");
        this.totalHits = totalHits;
        this.totalHitsRelation = totalHitsRelation;
        this.maxScore = maxScore;
        this.scrollId = scrollId;
        this.pointInTimeId = pointInTimeId;
        this.searchHits = searchHits;
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.unmodifiableSearchHits = Lazy.of(() -> Collections.unmodifiableList(searchHits));
    }

    @Override
    public long getTotalHits() {
        return this.totalHits;
    }

    @Override
    public TotalHitsRelation getTotalHitsRelation() {
        return this.totalHitsRelation;
    }

    @Override
    public float getMaxScore() {
        return this.maxScore;
    }

    @Override
    @Nullable
    public String getScrollId() {
        return this.scrollId;
    }

    @Override
    public List<SearchHit<T>> getSearchHits() {
        return (List)this.unmodifiableSearchHits.get();
    }

    @Override
    public SearchHit<T> getSearchHit(int index) {
        return this.searchHits.get(index);
    }

    @Override
    @Nullable
    public AggregationsContainer<?> getAggregations() {
        return this.aggregations;
    }

    @Override
    @Nullable
    public Suggest getSuggest() {
        return this.suggest;
    }

    @Override
    @Nullable
    public String getPointInTimeId() {
        return this.pointInTimeId;
    }

    public String toString() {
        return "SearchHits{totalHits=" + this.totalHits + ", totalHitsRelation=" + this.totalHitsRelation + ", maxScore=" + this.maxScore + ", scrollId='" + this.scrollId + "', pointInTimeId='" + this.pointInTimeId + "', searchHits={" + this.searchHits.size() + " elements}, aggregations=" + this.aggregations + "}";
    }
}

