/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import java.time.Duration;
import org.springframework.data.elasticsearch.core.index.ComponentTemplateRequestData;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public record PutComponentTemplateRequest(String name, @Nullable Long version, @Nullable Boolean create, @Nullable Duration masterTimeout, ComponentTemplateRequestData template) {
    public PutComponentTemplateRequest {
        Assert.notNull((Object)name, (String)"name must not be null");
        Assert.notNull((Object)template, (String)"template must not be null");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String name;
        @Nullable
        private Long version;
        @Nullable
        private Boolean create;
        @Nullable
        private Duration masterTimeout;
        @Nullable
        private ComponentTemplateRequestData template;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withVersion(Long version) {
            this.version = version;
            return this;
        }

        public Builder withCreate(Boolean create) {
            this.create = create;
            return this;
        }

        public Builder withMasterTimeout(Duration masterTimeout) {
            this.masterTimeout = masterTimeout;
            return this;
        }

        public Builder withTemplateData(ComponentTemplateRequestData template) {
            this.template = template;
            return this;
        }

        public PutComponentTemplateRequest build() {
            Assert.notNull((Object)this.name, (String)"name must not be null");
            Assert.notNull((Object)this.template, (String)"template must not be null");
            return new PutComponentTemplateRequest(this.name, this.version, this.create, this.masterTimeout, this.template);
        }
    }
}

