/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;

public class Version {
    private static final Pattern PATTERN = Pattern.compile("^(\\d+)(\\.(\\d+))?(\\.(\\d+))?.*$");
    private final int major;
    private final int minor;
    private final int revision;

    public Version(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }

    public static Version fromString(String s) {
        Assert.notNull((Object)s, (String)"s must not be null");
        Matcher matcher = PATTERN.matcher(s);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("invalid input pattern");
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = matcher.group(3) != null ? Integer.parseInt(matcher.group(3)) : 0;
        int revision = matcher.group(5) != null ? Integer.parseInt(matcher.group(5)) : 0;
        return new Version(major, minor, revision);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getRevision() {
        return this.revision;
    }
}

