/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.Iterator;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameterAccessor;
import org.springframework.lang.Nullable;

public class ConvertingParameterAccessor
implements ElasticsearchParameterAccessor {
    private final ElasticsearchConverter converter;
    private final ElasticsearchParameterAccessor delegate;

    public ConvertingParameterAccessor(ElasticsearchConverter converter, ElasticsearchParameterAccessor delegate) {
        this.converter = converter;
        this.delegate = delegate;
    }

    @Override
    public Object[] getValues() {
        return this.delegate.getValues();
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public Class<?> findDynamicProjection() {
        return this.delegate.findDynamicProjection();
    }

    public Object getBindableValue(int index) {
        return this.getConvertedValue(this.delegate.getBindableValue(index));
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    public Iterator<Object> iterator() {
        return this.delegate.iterator();
    }

    @Nullable
    private Object getConvertedValue(Object value) {
        if (value == null) {
            return "null";
        }
        if (this.converter.getConversionService().canConvert(value.getClass(), String.class)) {
            return this.converter.getConversionService().convert(value, String.class);
        }
        return value.toString();
    }
}

