/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.Objects;

public final class SeqNoPrimaryTerm {
    private final long sequenceNumber;
    private final long primaryTerm;

    public SeqNoPrimaryTerm(long sequenceNumber, long primaryTerm) {
        if (sequenceNumber < 0L) {
            throw new IllegalArgumentException("seq_no should not be negative, but it's " + sequenceNumber);
        }
        if (primaryTerm <= 0L) {
            throw new IllegalArgumentException("primary_term should be positive, but it's " + primaryTerm);
        }
        this.sequenceNumber = sequenceNumber;
        this.primaryTerm = primaryTerm;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String toString() {
        return "SeqNoPrimaryTerm{sequenceNumber=" + this.sequenceNumber + ", primaryTerm=" + this.primaryTerm + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeqNoPrimaryTerm that = (SeqNoPrimaryTerm)o;
        return this.sequenceNumber == that.sequenceNumber && this.primaryTerm == that.primaryTerm;
    }

    public int hashCode() {
        return Objects.hash(this.sequenceNumber, this.primaryTerm);
    }
}

