/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.document.Explanation;
import org.springframework.data.elasticsearch.core.document.NestedMetaData;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SearchHit<T> {
    @Nullable
    private final String index;
    @Nullable
    private final String id;
    private final float score;
    private final List<Object> sortValues;
    private final T content;
    private final Map<String, List<String>> highlightFields = new LinkedHashMap<String, List<String>>();
    private final Map<String, SearchHits<?>> innerHits = new LinkedHashMap();
    @Nullable
    private final NestedMetaData nestedMetaData;
    @Nullable
    private final String routing;
    @Nullable
    private final Explanation explanation;
    private final List<String> matchedQueries = new ArrayList<String>();

    @Deprecated
    public SearchHit(@Nullable String index, @Nullable String id, @Nullable String routing, float score, @Nullable Object[] sortValues, @Nullable Map<String, List<String>> highlightFields, T content) {
        this(index, id, routing, score, sortValues, highlightFields, null, null, null, null, content);
    }

    public SearchHit(@Nullable String index, @Nullable String id, @Nullable String routing, float score, @Nullable Object[] sortValues, @Nullable Map<String, List<String>> highlightFields, @Nullable Map<String, SearchHits<?>> innerHits, @Nullable NestedMetaData nestedMetaData, @Nullable Explanation explanation, @Nullable List<String> matchedQueries, T content) {
        this.index = index;
        this.id = id;
        this.routing = routing;
        this.score = score;
        List<Object> list = this.sortValues = sortValues != null ? Arrays.asList(sortValues) : new ArrayList<Object>();
        if (highlightFields != null) {
            this.highlightFields.putAll(highlightFields);
        }
        if (innerHits != null) {
            this.innerHits.putAll(innerHits);
        }
        this.nestedMetaData = nestedMetaData;
        this.explanation = explanation;
        this.content = content;
        if (matchedQueries != null) {
            this.matchedQueries.addAll(matchedQueries);
        }
    }

    @Nullable
    public String getIndex() {
        return this.index;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public float getScore() {
        return this.score;
    }

    public T getContent() {
        return this.content;
    }

    public List<Object> getSortValues() {
        return Collections.unmodifiableList(this.sortValues);
    }

    public Map<String, List<String>> getHighlightFields() {
        return Collections.unmodifiableMap(this.highlightFields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.unmodifiableList((List)entry.getValue()))));
    }

    public List<String> getHighlightField(String field) {
        Assert.notNull((Object)field, (String)"field must not be null");
        return Collections.unmodifiableList(this.highlightFields.getOrDefault(field, Collections.emptyList()));
    }

    @Nullable
    public SearchHits<?> getInnerHits(String name) {
        return this.innerHits.get(name);
    }

    public Map<String, SearchHits<?>> getInnerHits() {
        return this.innerHits;
    }

    @Nullable
    public NestedMetaData getNestedMetaData() {
        return this.nestedMetaData;
    }

    public String toString() {
        return "SearchHit{id='" + this.id + "', score=" + this.score + ", sortValues=" + this.sortValues + ", content=" + this.content + ", highlightFields=" + this.highlightFields + "}";
    }

    @Nullable
    public String getRouting() {
        return this.routing;
    }

    @Nullable
    public Explanation getExplanation() {
        return this.explanation;
    }

    @Nullable
    public List<String> getMatchedQueries() {
        return this.matchedQueries;
    }
}

