/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.EntityOperations;
import org.springframework.data.elasticsearch.core.IndexedObjectInformation;
import org.springframework.data.elasticsearch.core.MultiGetItem;
import org.springframework.data.elasticsearch.core.RefreshPolicy;
import org.springframework.data.elasticsearch.core.SearchHitMapping;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.StreamQueries;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.convert.MappingElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.event.AfterConvertCallback;
import org.springframework.data.elasticsearch.core.event.AfterLoadCallback;
import org.springframework.data.elasticsearch.core.event.AfterSaveCallback;
import org.springframework.data.elasticsearch.core.event.BeforeConvertCallback;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.mapping.SimpleElasticsearchMappingContext;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.ByQueryResponse;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.IndexQueryBuilder;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SeqNoPrimaryTerm;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.routing.DefaultRoutingResolver;
import org.springframework.data.elasticsearch.core.routing.RoutingResolver;
import org.springframework.data.elasticsearch.support.VersionInfo;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.Streamable;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractElasticsearchTemplate
implements ElasticsearchOperations,
ApplicationContextAware {
    protected ElasticsearchConverter elasticsearchConverter;
    protected EntityOperations entityOperations;
    @Nullable
    protected EntityCallbacks entityCallbacks;
    @Nullable
    protected RefreshPolicy refreshPolicy;
    protected RoutingResolver routingResolver;

    public AbstractElasticsearchTemplate() {
        this(null);
    }

    public AbstractElasticsearchTemplate(@Nullable ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter != null ? elasticsearchConverter : this.createElasticsearchConverter();
        MappingContext mappingContext = this.elasticsearchConverter.getMappingContext();
        this.entityOperations = new EntityOperations(mappingContext);
        this.routingResolver = new DefaultRoutingResolver((MappingContext<? extends ElasticsearchPersistentEntity, ? extends ElasticsearchPersistentProperty>)mappingContext);
        VersionInfo.versionProperties();
    }

    private AbstractElasticsearchTemplate copy() {
        AbstractElasticsearchTemplate copy = this.doCopy();
        if (this.entityCallbacks != null) {
            copy.setEntityCallbacks(this.entityCallbacks);
        }
        copy.setRoutingResolver(this.routingResolver);
        copy.setRefreshPolicy(this.refreshPolicy);
        return copy;
    }

    protected abstract AbstractElasticsearchTemplate doCopy();

    private ElasticsearchConverter createElasticsearchConverter() {
        MappingElasticsearchConverter mappingElasticsearchConverter = new MappingElasticsearchConverter((MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty>)new SimpleElasticsearchMappingContext());
        mappingElasticsearchConverter.afterPropertiesSet();
        return mappingElasticsearchConverter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
        if (this.elasticsearchConverter instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.elasticsearchConverter).setApplicationContext(applicationContext);
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"entityCallbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    public void setRefreshPolicy(@Nullable RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
    }

    @Nullable
    public RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void logVersions() {
        VersionInfo.logVersions(this.getVendor(), this.getRuntimeLibraryVersion(), this.getClusterVersion());
    }

    @Override
    public <T> T save(T entity) {
        Assert.notNull(entity, (String)"entity must not be null");
        return this.save(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public <T> T save(T entity, IndexCoordinates index) {
        Assert.notNull(entity, (String)"entity must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        T entityAfterBeforeConvert = this.maybeCallbackBeforeConvert(entity, index);
        IndexQuery query = this.getIndexQuery(entityAfterBeforeConvert);
        this.doIndex(query, index);
        return (T)this.maybeCallbackAfterSave(Objects.requireNonNull(query.getObject()), index);
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities) {
        Assert.notNull(entities, (String)"entities must not be null");
        Iterator<T> iterator = entities.iterator();
        if (iterator.hasNext()) {
            return this.save(entities, this.getIndexCoordinatesFor(iterator.next().getClass()));
        }
        return entities;
    }

    @Override
    public <T> Iterable<T> save(Iterable<T> entities, IndexCoordinates index) {
        Assert.notNull(entities, (String)"entities must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        List<IndexQuery> indexQueries = Streamable.of(entities).stream().map(this::getIndexQuery).collect(Collectors.toList());
        if (indexQueries.isEmpty()) {
            return Collections.emptyList();
        }
        List<IndexedObjectInformation> indexedObjectInformationList = this.bulkIndex(indexQueries, index);
        Iterator<IndexedObjectInformation> iterator = indexedObjectInformationList.iterator();
        return indexQueries.stream().map(IndexQuery::getObject).map(entity -> this.updateIndexedObject(entity, (IndexedObjectInformation)iterator.next())).collect(Collectors.toList());
    }

    @Override
    @SafeVarargs
    public final <T> Iterable<T> save(T ... entities) {
        return this.save((Iterable<T>)Arrays.asList(entities));
    }

    @Override
    public String index(IndexQuery query, IndexCoordinates index) {
        this.maybeCallbackBeforeConvertWithQuery(query, index);
        String documentId = this.doIndex(query, index);
        this.maybeCallbackAfterSaveWithQuery(query, index);
        return documentId;
    }

    public abstract String doIndex(IndexQuery var1, IndexCoordinates var2);

    @Override
    @Nullable
    public <T> T get(String id, Class<T> clazz) {
        return this.get(id, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> List<MultiGetItem<T>> multiGet(Query query, Class<T> clazz) {
        return this.multiGet(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public boolean exists(String id, Class<?> clazz) {
        return this.exists(id, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public boolean exists(String id, IndexCoordinates index) {
        return this.doExists(id, index);
    }

    protected abstract boolean doExists(String var1, IndexCoordinates var2);

    @Override
    public String delete(String id, Class<?> entityType) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull(entityType, (String)"entityType must not be null");
        return this.delete(id, this.getIndexCoordinatesFor(entityType));
    }

    @Override
    public ByQueryResponse delete(Query query, Class<?> clazz) {
        return this.delete(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public String delete(Object entity) {
        return this.delete(entity, this.getIndexCoordinatesFor(entity.getClass()));
    }

    @Override
    public String delete(Object entity, IndexCoordinates index) {
        String entityId = this.getEntityId(entity);
        Assert.notNull((Object)entityId, (String)"entity must have an if that is notnull");
        return this.delete(entityId, index);
    }

    @Override
    public String delete(String id, IndexCoordinates index) {
        return this.doDelete(id, this.routingResolver.getRouting(), index);
    }

    @Override
    @Deprecated
    public final String delete(String id, @Nullable String routing, IndexCoordinates index) {
        return this.doDelete(id, routing, index);
    }

    protected abstract String doDelete(String var1, @Nullable String var2, IndexCoordinates var3);

    @Override
    public List<IndexedObjectInformation> bulkIndex(List<IndexQuery> queries, Class<?> clazz) {
        return this.bulkIndex(queries, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public List<IndexedObjectInformation> bulkIndex(List<IndexQuery> queries, BulkOptions bulkOptions, Class<?> clazz) {
        return this.bulkIndex(queries, bulkOptions, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public final List<IndexedObjectInformation> bulkIndex(List<IndexQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of IndexQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        return this.bulkOperation(queries, bulkOptions, index);
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries, Class<?> clazz) {
        this.bulkUpdate(queries, this.getIndexCoordinatesFor(clazz));
    }

    public List<IndexedObjectInformation> bulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of IndexQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        this.maybeCallbackBeforeConvertWithQueries(queries, index);
        List<IndexedObjectInformation> indexedObjectInformationList = this.doBulkOperation(queries, bulkOptions, index);
        this.maybeCallbackAfterSaveWithQueries(queries, index);
        return indexedObjectInformationList;
    }

    public abstract List<IndexedObjectInformation> doBulkOperation(List<?> var1, BulkOptions var2, IndexCoordinates var3);

    @Override
    public long count(Query query, Class<?> clazz) {
        return this.count(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> SearchHitsIterator<T> searchForStream(Query query, Class<T> clazz) {
        return this.searchForStream(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> SearchHitsIterator<T> searchForStream(Query query, Class<T> clazz, IndexCoordinates index) {
        Duration scrollTime = query.getScrollTime() != null ? query.getScrollTime() : Duration.ofMinutes(1L);
        long scrollTimeInMillis = scrollTime.toMillis();
        int maxCount = query.isLimiting() ? query.getMaxResults() : 0;
        return StreamQueries.streamResults(maxCount, this.searchScrollStart(scrollTimeInMillis, query, clazz, index), scrollId -> this.searchScrollContinue((String)scrollId, scrollTimeInMillis, clazz, index), this::searchScrollClear);
    }

    @Override
    public <T> SearchHits<T> search(MoreLikeThisQuery query, Class<T> clazz) {
        return this.search(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> SearchHits<T> search(MoreLikeThisQuery query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query.getId(), (String)"No document id defined for MoreLikeThisQuery");
        return this.doSearch(query, clazz, index);
    }

    protected abstract <T> SearchHits<T> doSearch(MoreLikeThisQuery var1, Class<T> var2, IndexCoordinates var3);

    @Override
    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> queries, Class<T> clazz) {
        return this.multiSearch(queries, clazz, this.getIndexCoordinatesFor(clazz));
    }

    @Override
    public <T> SearchHits<T> search(Query query, Class<T> clazz) {
        return this.search(query, clazz, this.getIndexCoordinatesFor(clazz));
    }

    protected abstract <T> SearchScrollHits<T> searchScrollStart(long var1, Query var3, Class<T> var4, IndexCoordinates var5);

    protected abstract <T> SearchScrollHits<T> searchScrollContinue(String var1, long var2, Class<T> var4, IndexCoordinates var5);

    protected void searchScrollClear(String scrollId) {
        this.searchScrollClear(Collections.singletonList(scrollId));
    }

    protected abstract void searchScrollClear(List<String> var1);

    @Override
    public ElasticsearchConverter getElasticsearchConverter() {
        Assert.notNull((Object)this.elasticsearchConverter, (String)"elasticsearchConverter is not initialized.");
        return this.elasticsearchConverter;
    }

    protected static String[] toArray(List<String> values) {
        String[] valuesAsArray = new String[values.size()];
        return values.toArray(valuesAsArray);
    }

    @Override
    public IndexCoordinates getIndexCoordinatesFor(Class<?> clazz) {
        return this.getRequiredPersistentEntity(clazz).getIndexCoordinates();
    }

    protected <T> T updateIndexedObject(T entity, IndexedObjectInformation indexedObjectInformation) {
        ElasticsearchPersistentEntity persistentEntity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity(entity.getClass());
        if (persistentEntity != null) {
            PersistentPropertyAccessor propertyAccessor = persistentEntity.getPropertyAccessor(entity);
            ElasticsearchPersistentProperty idProperty = (ElasticsearchPersistentProperty)persistentEntity.getIdProperty();
            if (indexedObjectInformation.getId() != null && idProperty != null && idProperty.getType().isAssignableFrom(String.class)) {
                propertyAccessor.setProperty((PersistentProperty)idProperty, (Object)indexedObjectInformation.getId());
            }
            if (indexedObjectInformation.getSeqNo() != null && indexedObjectInformation.getPrimaryTerm() != null && persistentEntity.hasSeqNoPrimaryTermProperty()) {
                ElasticsearchPersistentProperty seqNoPrimaryTermProperty = persistentEntity.getSeqNoPrimaryTermProperty();
                propertyAccessor.setProperty((PersistentProperty)seqNoPrimaryTermProperty, (Object)new SeqNoPrimaryTerm(indexedObjectInformation.getSeqNo(), indexedObjectInformation.getPrimaryTerm()));
            }
            if (indexedObjectInformation.getVersion() != null && persistentEntity.hasVersionProperty()) {
                ElasticsearchPersistentProperty versionProperty = persistentEntity.getVersionProperty();
                propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)indexedObjectInformation.getVersion());
            }
            return (T)propertyAccessor.getBean();
        }
        return entity;
    }

    ElasticsearchPersistentEntity<?> getRequiredPersistentEntity(Class<?> clazz) {
        return (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
    }

    @Nullable
    private String getEntityId(Object entity) {
        Object id = this.entityOperations.forEntity(entity, this.elasticsearchConverter.getConversionService(), this.routingResolver).getId();
        if (id != null) {
            return this.stringIdRepresentation(id);
        }
        return null;
    }

    @Override
    @Nullable
    public String getEntityRouting(Object entity) {
        return this.entityOperations.forEntity(entity, this.elasticsearchConverter.getConversionService(), this.routingResolver).getRouting();
    }

    @Nullable
    private Long getEntityVersion(Object entity) {
        Number version = this.entityOperations.forEntity(entity, this.elasticsearchConverter.getConversionService(), this.routingResolver).getVersion();
        if (version != null && Long.class.isAssignableFrom(version.getClass())) {
            return (Long)version;
        }
        return null;
    }

    @Nullable
    private SeqNoPrimaryTerm getEntitySeqNoPrimaryTerm(Object entity) {
        EntityOperations.AdaptableEntity<Object> adaptableEntity = this.entityOperations.forEntity(entity, this.elasticsearchConverter.getConversionService(), this.routingResolver);
        return adaptableEntity.hasSeqNoPrimaryTerm() ? adaptableEntity.getSeqNoPrimaryTerm() : null;
    }

    private <T> IndexQuery getIndexQuery(T entity) {
        String id = this.getEntityId(entity);
        if (id != null) {
            id = this.elasticsearchConverter.convertId(id);
        }
        IndexQueryBuilder builder = new IndexQueryBuilder().withId(id).withObject(entity);
        SeqNoPrimaryTerm seqNoPrimaryTerm = this.getEntitySeqNoPrimaryTerm(entity);
        if (seqNoPrimaryTerm != null) {
            builder.withSeqNoPrimaryTerm(seqNoPrimaryTerm);
        } else {
            builder.withVersion(this.getEntityVersion(entity));
        }
        String routing = this.getEntityRouting(entity);
        if (routing != null) {
            builder.withRouting(routing);
        }
        return builder.build();
    }

    protected <T> SearchDocumentResponse.EntityCreator<T> getEntityCreator(ReadDocumentCallback<T> documentCallback) {
        return searchDocument -> CompletableFuture.completedFuture(documentCallback.doWith((Document)searchDocument));
    }

    @Nullable
    protected abstract String getClusterVersion();

    protected abstract String getVendor();

    protected abstract String getRuntimeLibraryVersion();

    protected <T> T maybeCallbackBeforeConvert(T entity, IndexCoordinates index) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, entity, new Object[]{index});
        }
        return entity;
    }

    protected void maybeCallbackBeforeConvertWithQuery(Object query, IndexCoordinates index) {
        IndexQuery indexQuery;
        Object queryObject;
        if (query instanceof IndexQuery && (queryObject = (indexQuery = (IndexQuery)query).getObject()) != null) {
            queryObject = this.maybeCallbackBeforeConvert(queryObject, index);
            indexQuery.setObject(queryObject);
            IndexQuery newQuery = this.getIndexQuery(queryObject);
            if (indexQuery.getRouting() == null && newQuery.getRouting() != null) {
                indexQuery.setRouting(newQuery.getRouting());
            }
            if (indexQuery.getSeqNo() == null && newQuery.getSeqNo() != null) {
                indexQuery.setSeqNo(newQuery.getSeqNo());
            }
            if (indexQuery.getPrimaryTerm() == null && newQuery.getPrimaryTerm() != null) {
                indexQuery.setPrimaryTerm(newQuery.getPrimaryTerm());
            }
        }
    }

    protected void maybeCallbackBeforeConvertWithQueries(List<?> queries, IndexCoordinates index) {
        queries.forEach(query -> this.maybeCallbackBeforeConvertWithQuery(query, index));
    }

    protected <T> T maybeCallbackAfterSave(T entity, IndexCoordinates index) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(AfterSaveCallback.class, entity, new Object[]{index});
        }
        return entity;
    }

    protected void maybeCallbackAfterSaveWithQuery(Object query, IndexCoordinates index) {
        IndexQuery indexQuery;
        Object queryObject;
        if (query instanceof IndexQuery && (queryObject = (indexQuery = (IndexQuery)query).getObject()) != null) {
            queryObject = this.maybeCallbackAfterSave(queryObject, index);
            indexQuery.setObject(queryObject);
        }
    }

    protected void maybeCallbackAfterSaveWithQueries(List<?> queries, IndexCoordinates index) {
        queries.forEach(query -> this.maybeCallbackAfterSaveWithQuery(query, index));
    }

    protected <T> T maybeCallbackAfterConvert(T entity, Document document, IndexCoordinates index) {
        if (this.entityCallbacks != null) {
            return (T)this.entityCallbacks.callback(AfterConvertCallback.class, entity, new Object[]{document, index});
        }
        return entity;
    }

    protected <T> Document maybeCallbackAfterLoad(Document document, Class<T> type, IndexCoordinates indexCoordinates) {
        if (this.entityCallbacks != null) {
            return (Document)this.entityCallbacks.callback(AfterLoadCallback.class, (Object)document, new Object[]{type, indexCoordinates});
        }
        return document;
    }

    protected void updateIndexedObjectsWithQueries(List<?> queries, List<IndexedObjectInformation> indexedObjectInformationList) {
        for (int i = 0; i < queries.size(); ++i) {
            IndexQuery indexQuery;
            Object queryObject;
            Object query = queries.get(i);
            if (!(query instanceof IndexQuery) || (queryObject = (indexQuery = (IndexQuery)query).getObject()) == null) continue;
            indexQuery.setObject(this.updateIndexedObject(queryObject, indexedObjectInformationList.get(i)));
        }
    }

    private void setRoutingResolver(RoutingResolver routingResolver) {
        Assert.notNull((Object)routingResolver, (String)"routingResolver must not be null");
        this.routingResolver = routingResolver;
    }

    @Override
    public ElasticsearchOperations withRouting(RoutingResolver routingResolver) {
        Assert.notNull((Object)routingResolver, (String)"routingResolver must not be null");
        AbstractElasticsearchTemplate copy = this.copy();
        copy.setRoutingResolver(routingResolver);
        return copy;
    }

    protected class ReadDocumentCallback<T>
    implements DocumentCallback<T> {
        private final EntityReader<? super T, Document> reader;
        private final Class<T> type;
        private final IndexCoordinates index;

        public ReadDocumentCallback(EntityReader<? super T, Document> reader, Class<T> type, IndexCoordinates index) {
            Assert.notNull(reader, (String)"reader is null");
            Assert.notNull(type, (String)"type is null");
            this.reader = reader;
            this.type = type;
            this.index = index;
        }

        @Override
        @Nullable
        public T doWith(@Nullable Document document) {
            if (document == null) {
                return null;
            }
            Document documentAfterLoad = AbstractElasticsearchTemplate.this.maybeCallbackAfterLoad(document, this.type, this.index);
            Object entity = this.reader.read(this.type, (Object)documentAfterLoad);
            IndexedObjectInformation indexedObjectInformation = IndexedObjectInformation.of(documentAfterLoad.hasId() ? documentAfterLoad.getId() : null, documentAfterLoad.getSeqNo(), documentAfterLoad.getPrimaryTerm(), documentAfterLoad.getVersion());
            entity = AbstractElasticsearchTemplate.this.updateIndexedObject(entity, indexedObjectInformation);
            return (T)AbstractElasticsearchTemplate.this.maybeCallbackAfterConvert(entity, documentAfterLoad, this.index);
        }
    }

    protected class ReadSearchScrollDocumentResponseCallback<T>
    implements SearchDocumentResponseCallback<SearchScrollHits<T>> {
        private final DocumentCallback<T> delegate;
        private final Class<T> type;

        public ReadSearchScrollDocumentResponseCallback(Class<T> type, IndexCoordinates index) {
            Assert.notNull(type, (String)"type is null");
            this.delegate = new ReadDocumentCallback<T>(AbstractElasticsearchTemplate.this.elasticsearchConverter, type, index);
            this.type = type;
        }

        @Override
        @NonNull
        public SearchScrollHits<T> doWith(SearchDocumentResponse response) {
            List entities = response.getSearchDocuments().stream().map(this.delegate::doWith).collect(Collectors.toList());
            return SearchHitMapping.mappingFor(this.type, AbstractElasticsearchTemplate.this.elasticsearchConverter).mapScrollHits(response, entities);
        }
    }

    protected class ReadSearchDocumentResponseCallback<T>
    implements SearchDocumentResponseCallback<SearchHits<T>> {
        private final DocumentCallback<T> delegate;
        private final Class<T> type;

        public ReadSearchDocumentResponseCallback(Class<T> type, IndexCoordinates index) {
            Assert.notNull(type, (String)"type is null");
            this.delegate = new ReadDocumentCallback<T>(AbstractElasticsearchTemplate.this.elasticsearchConverter, type, index);
            this.type = type;
        }

        @Override
        @NonNull
        public SearchHits<T> doWith(SearchDocumentResponse response) {
            List entities = response.getSearchDocuments().stream().map(this.delegate::doWith).collect(Collectors.toList());
            return SearchHitMapping.mappingFor(this.type, AbstractElasticsearchTemplate.this.elasticsearchConverter).mapHits(response, entities);
        }
    }

    protected static interface SearchDocumentResponseCallback<T> {
        @NonNull
        public T doWith(@NonNull SearchDocumentResponse var1);
    }

    protected static interface DocumentCallback<T> {
        @Nullable
        public T doWith(@Nullable Document var1);
    }
}

