/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.data.elasticsearch.client.ElasticsearchHost;
import org.springframework.data.elasticsearch.client.reactive.MultiNodeHostProvider;
import org.springframework.data.elasticsearch.client.reactive.SingleNodeHostProvider;
import org.springframework.data.elasticsearch.client.reactive.WebClientProvider;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public interface HostProvider<T extends HostProvider<T>> {
    public static HostProvider<?> provider(WebClientProvider clientProvider, Supplier<HttpHeaders> headersSupplier, InetSocketAddress ... endpoints) {
        Assert.notNull((Object)clientProvider, (String)"WebClientProvider must not be null");
        Assert.notEmpty((Object[])endpoints, (String)"Please provide at least one endpoint to connect to.");
        if (endpoints.length == 1) {
            return new SingleNodeHostProvider(clientProvider, endpoints[0]);
        }
        return new MultiNodeHostProvider(clientProvider, endpoints);
    }

    default public Mono<InetSocketAddress> lookupActiveHost() {
        return this.lookupActiveHost(Verification.LAZY);
    }

    public Mono<InetSocketAddress> lookupActiveHost(Verification var1);

    default public Mono<WebClient> getActive() {
        return this.getActive(Verification.LAZY);
    }

    default public Mono<WebClient> getActive(Verification verification) {
        return this.lookupActiveHost(verification).map(this::createWebClient);
    }

    default public Mono<WebClient> getWebClient() {
        return this.getWebClient(Verification.LAZY);
    }

    default public Mono<WebClient> getWebClient(Verification verification) {
        return this.lookupActiveHost(verification).map(this::createWebClient);
    }

    public WebClient createWebClient(InetSocketAddress var1);

    public Mono<ClusterInformation> clusterInfo();

    public static enum Verification {
        ACTIVE,
        LAZY;

    }

    public static class ClusterInformation {
        private final Set<ElasticsearchHost> nodes;

        public ClusterInformation(Set<ElasticsearchHost> nodes) {
            this.nodes = nodes;
        }

        public Set<ElasticsearchHost> getNodes() {
            return Collections.unmodifiableSet(this.nodes);
        }
    }
}

