/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public abstract class ClientLogger {
    private static final Log WIRE_LOGGER = LogFactory.getLog((String)"org.springframework.data.elasticsearch.client.WIRE");

    private ClientLogger() {
    }

    public static boolean isEnabled() {
        return WIRE_LOGGER.isTraceEnabled();
    }

    public static void logRequest(String logId, String method, String endpoint, Object parameters) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Sending request %s %s with parameters: %s", logId, method.toUpperCase(), endpoint, parameters));
        }
    }

    public static void logRequest(String logId, String method, String endpoint, Object parameters, String headers) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Sending request%n%s %s%nParameters: %s%nHeaders: %s", logId, method.toUpperCase(), endpoint, parameters, headers));
        }
    }

    public static void logRequest(String logId, String method, String endpoint, Object parameters, Supplier<Object> body) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Sending request %s %s with parameters: %s%nRequest body: %s", logId, method.toUpperCase(), endpoint, parameters, body.get()));
        }
    }

    public static void logRequest(String logId, String method, String endpoint, Object parameters, String headers, Supplier<Object> body) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Sending request%n%s %s%nParameters: %s%nHeaders: %s%nRequest body: %s", logId, method.toUpperCase(), endpoint, parameters, headers, body.get()));
        }
    }

    public static void logRawResponse(String logId, @Nullable HttpStatusCode statusCode) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Received raw response: %s", logId, statusCode));
        }
    }

    public static void logRawResponse(String logId, @Nullable HttpStatus statusCode, String headers) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Received response: %s%n%s", logId, statusCode, headers));
        }
    }

    public static void logResponse(String logId, HttpStatusCode statusCode, String body) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Received response: %s%nResponse body: %s", logId, statusCode, body));
        }
    }

    public static void logResponse(String logId, @Nullable HttpStatus statusCode, String headers, String body) {
        if (ClientLogger.isEnabled()) {
            WIRE_LOGGER.trace((Object)String.format("[%s] Received response: %s%nHeaders: %s%nResponse body: %s", logId, statusCode, headers, body));
        }
    }

    public static String newLogId() {
        if (!ClientLogger.isEnabled()) {
            return "-";
        }
        return ObjectUtils.getIdentityHexString((Object)new Object());
    }
}

