/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.elasticsearch.core.convert.AbstractRangePropertyValueConverter;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchDateConverter;
import org.springframework.data.mapping.PersistentProperty;

public class DateRangePropertyValueConverter
extends AbstractRangePropertyValueConverter<Date> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateRangePropertyValueConverter.class);
    private final List<ElasticsearchDateConverter> dateConverters;

    public DateRangePropertyValueConverter(PersistentProperty<?> property, List<ElasticsearchDateConverter> dateConverters) {
        super(property);
        this.dateConverters = dateConverters;
    }

    @Override
    protected String format(Date value) {
        return this.dateConverters.get(0).format(value);
    }

    @Override
    protected Date parse(String value) {
        for (ElasticsearchDateConverter converters : this.dateConverters) {
            try {
                return converters.parse(value);
            }
            catch (Exception e) {
                LOGGER.trace(e.getMessage(), (Throwable)e);
            }
        }
        throw new ConversionException(String.format("Unable to convert value '%s' to %s for property '%s'", value, this.getGenericType().getTypeName(), this.getProperty().getName()));
    }
}

