/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.data.elasticsearch.client.ClientConfiguration;
import org.springframework.data.elasticsearch.client.ClientLogger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public final class RestClients {
    private static final String LOG_ID_ATTRIBUTE = RestClients.class.getName() + ".LOG_ID";

    private RestClients() {
    }

    public static ElasticsearchRestClient create(ClientConfiguration clientConfiguration) {
        HttpHeaders headers;
        Assert.notNull((Object)clientConfiguration, (String)"ClientConfiguration must not be null!");
        HttpHost[] httpHosts = (HttpHost[])RestClients.formattedHosts(clientConfiguration.getEndpoints(), clientConfiguration.useSsl()).stream().map(HttpHost::create).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts);
        if (clientConfiguration.getPathPrefix() != null) {
            builder.setPathPrefix(clientConfiguration.getPathPrefix());
        }
        if (!(headers = clientConfiguration.getDefaultHeaders()).isEmpty()) {
            builder.setDefaultHeaders(RestClients.toHeaderArray(headers));
        }
        builder.setHttpClientConfigCallback(clientBuilder -> {
            Duration socketTimeout;
            clientConfiguration.getSslContext().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLContext(arg_0));
            clientConfiguration.getHostNameVerifier().ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setSSLHostnameVerifier(arg_0));
            clientBuilder.addInterceptorLast((HttpRequestInterceptor)new CustomHeaderInjector(clientConfiguration.getHeadersSupplier()));
            if (ClientLogger.isEnabled()) {
                HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
                clientBuilder.addInterceptorLast((HttpRequestInterceptor)interceptor);
                clientBuilder.addInterceptorLast((HttpResponseInterceptor)interceptor);
            }
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            Duration connectTimeout = clientConfiguration.getConnectTimeout();
            if (!connectTimeout.isNegative()) {
                requestConfigBuilder.setConnectTimeout(Math.toIntExact(connectTimeout.toMillis()));
            }
            if (!(socketTimeout = clientConfiguration.getSocketTimeout()).isNegative()) {
                requestConfigBuilder.setSocketTimeout(Math.toIntExact(socketTimeout.toMillis()));
                requestConfigBuilder.setConnectionRequestTimeout(Math.toIntExact(socketTimeout.toMillis()));
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
            clientConfiguration.getProxy().map(HttpHost::create).ifPresent(arg_0 -> ((HttpAsyncClientBuilder)clientBuilder).setProxy(arg_0));
            clientBuilder = clientConfiguration.getHttpClientConfigurer().customizeHttpClient(clientBuilder);
            return clientBuilder;
        });
        RestHighLevelClient client = new RestHighLevelClient(builder);
        return () -> client;
    }

    private static Header[] toHeaderArray(HttpHeaders headers) {
        return (Header[])headers.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream().map(value -> new BasicHeader((String)entry.getKey(), value))).toArray(Header[]::new);
    }

    private static List<String> formattedHosts(List<InetSocketAddress> hosts, boolean useSsl) {
        return hosts.stream().map(it -> (useSsl ? "https" : "http") + "://" + it.getHostString() + ":" + it.getPort()).collect(Collectors.toList());
    }

    private static class CustomHeaderInjector
    implements HttpRequestInterceptor {
        private final Supplier<HttpHeaders> headersSupplier;

        public CustomHeaderInjector(Supplier<HttpHeaders> headersSupplier) {
            this.headersSupplier = headersSupplier;
        }

        public void process(HttpRequest request, HttpContext context) {
            HttpHeaders httpHeaders = this.headersSupplier.get();
            if (httpHeaders != null && httpHeaders != HttpHeaders.EMPTY) {
                Arrays.stream(RestClients.toHeaderArray(httpHeaders)).forEach(arg_0 -> ((HttpRequest)request).addHeader(arg_0));
            }
        }
    }

    private static class HttpLoggingInterceptor
    implements HttpResponseInterceptor,
    HttpRequestInterceptor {
        private HttpLoggingInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws IOException {
            String logId = (String)context.getAttribute(LOG_ID_ATTRIBUTE);
            if (logId == null) {
                logId = ClientLogger.newLogId();
                context.setAttribute(LOG_ID_ATTRIBUTE, (Object)logId);
            }
            if (request instanceof HttpEntityEnclosingRequest && ((HttpEntityEnclosingRequest)request).getEntity() != null) {
                HttpEntityEnclosingRequest entityRequest = (HttpEntityEnclosingRequest)request;
                HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                entity.writeTo((OutputStream)buffer);
                if (!entity.isRepeatable()) {
                    entityRequest.setEntity((HttpEntity)new ByteArrayEntity(buffer.toByteArray()));
                }
                ClientLogger.logRequest(logId, request.getRequestLine().getMethod(), request.getRequestLine().getUri(), "", () -> new String(buffer.toByteArray()));
            } else {
                ClientLogger.logRequest(logId, request.getRequestLine().getMethod(), request.getRequestLine().getUri(), "");
            }
        }

        public void process(HttpResponse response, HttpContext context) {
            String logId = (String)context.getAttribute(LOG_ID_ATTRIBUTE);
            ClientLogger.logRawResponse(logId, HttpStatus.resolve((int)response.getStatusLine().getStatusCode()));
        }
    }

    @FunctionalInterface
    public static interface ElasticsearchRestClient
    extends Closeable {
        public RestHighLevelClient rest();

        default public RestClient lowLevelRest() {
            return this.rest().getLowLevelClient();
        }

        @Override
        default public void close() throws IOException {
            this.rest().close();
        }
    }
}

