/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.IndexBoost;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.ScriptField;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class NativeSearchQueryBuilder {
    @Nullable
    private QueryBuilder queryBuilder;
    @Nullable
    private QueryBuilder filterBuilder;
    private final List<ScriptField> scriptFields = new ArrayList<ScriptField>();
    private final List<SortBuilder<?>> sortBuilders = new ArrayList();
    private final List<AbstractAggregationBuilder<?>> aggregationBuilders = new ArrayList();
    @Nullable
    private HighlightBuilder highlightBuilder;
    @Nullable
    private HighlightBuilder.Field[] highlightFields;
    private Pageable pageable = Pageable.unpaged();
    @Nullable
    private String[] fields;
    @Nullable
    private SourceFilter sourceFilter;
    @Nullable
    private CollapseBuilder collapseBuilder;
    @Nullable
    private List<IndexBoost> indicesBoost;
    private float minScore;
    private boolean trackScores;
    @Nullable
    private Collection<String> ids;
    @Nullable
    private String route;
    @Nullable
    private SearchType searchType;
    @Nullable
    private IndicesOptions indicesOptions;
    @Nullable
    private String preference;
    @Nullable
    private Integer maxResults;
    @Nullable
    private Boolean trackTotalHits;
    @Nullable
    private TimeValue timeout;

    public NativeSearchQueryBuilder withQuery(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withFilter(QueryBuilder filterBuilder) {
        this.filterBuilder = filterBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withSort(SortBuilder<?> sortBuilder) {
        this.sortBuilders.add(sortBuilder);
        return this;
    }

    public NativeSearchQueryBuilder withScriptField(ScriptField scriptField) {
        this.scriptFields.add(scriptField);
        return this;
    }

    public NativeSearchQueryBuilder withCollapseField(String collapseField) {
        this.collapseBuilder = new CollapseBuilder(collapseField);
        return this;
    }

    public NativeSearchQueryBuilder addAggregation(AbstractAggregationBuilder<?> aggregationBuilder) {
        this.aggregationBuilders.add(aggregationBuilder);
        return this;
    }

    public NativeSearchQueryBuilder withHighlightBuilder(HighlightBuilder highlightBuilder) {
        this.highlightBuilder = highlightBuilder;
        return this;
    }

    public NativeSearchQueryBuilder withHighlightFields(HighlightBuilder.Field ... highlightFields) {
        this.highlightFields = highlightFields;
        return this;
    }

    public NativeSearchQueryBuilder withIndicesBoost(List<IndexBoost> indicesBoost) {
        this.indicesBoost = indicesBoost;
        return this;
    }

    public NativeSearchQueryBuilder withPageable(Pageable pageable) {
        this.pageable = pageable;
        return this;
    }

    public NativeSearchQueryBuilder withFields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public NativeSearchQueryBuilder withSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
        return this;
    }

    public NativeSearchQueryBuilder withMinScore(float minScore) {
        this.minScore = minScore;
        return this;
    }

    public NativeSearchQueryBuilder withTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
        return this;
    }

    public NativeSearchQueryBuilder withIds(Collection<String> ids) {
        this.ids = ids;
        return this;
    }

    public NativeSearchQueryBuilder withRoute(String route) {
        this.route = route;
        return this;
    }

    public NativeSearchQueryBuilder withSearchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public NativeSearchQueryBuilder withIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public NativeSearchQueryBuilder withPreference(String preference) {
        this.preference = preference;
        return this;
    }

    public NativeSearchQueryBuilder withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public NativeSearchQueryBuilder withTrackTotalHits(Boolean trackTotalHits) {
        this.trackTotalHits = trackTotalHits;
        return this;
    }

    public NativeSearchQueryBuilder withTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public NativeSearchQuery build() {
        NativeSearchQuery nativeSearchQuery = new NativeSearchQuery(this.queryBuilder, this.filterBuilder, this.sortBuilders, this.highlightBuilder, this.highlightFields);
        nativeSearchQuery.setPageable(this.pageable);
        nativeSearchQuery.setTrackScores(this.trackScores);
        if (this.fields != null) {
            nativeSearchQuery.addFields(this.fields);
        }
        if (this.sourceFilter != null) {
            nativeSearchQuery.addSourceFilter(this.sourceFilter);
        }
        if (this.indicesBoost != null) {
            nativeSearchQuery.setIndicesBoost(this.indicesBoost);
        }
        if (!CollectionUtils.isEmpty(this.scriptFields)) {
            nativeSearchQuery.setScriptFields(this.scriptFields);
        }
        if (this.collapseBuilder != null) {
            nativeSearchQuery.setCollapseBuilder(this.collapseBuilder);
        }
        if (!CollectionUtils.isEmpty(this.aggregationBuilders)) {
            nativeSearchQuery.setAggregations(this.aggregationBuilders);
        }
        if (this.minScore > 0.0f) {
            nativeSearchQuery.setMinScore(this.minScore);
        }
        if (this.ids != null) {
            nativeSearchQuery.setIds((Collection)this.ids);
        }
        if (this.route != null) {
            nativeSearchQuery.setRoute(this.route);
        }
        if (this.searchType != null) {
            nativeSearchQuery.setSearchType(this.searchType);
        }
        if (this.indicesOptions != null) {
            nativeSearchQuery.setIndicesOptions(this.indicesOptions);
        }
        if (this.preference != null) {
            nativeSearchQuery.setPreference(this.preference);
        }
        if (this.maxResults != null) {
            nativeSearchQuery.setMaxResults(this.maxResults);
        }
        nativeSearchQuery.setTrackTotalHits(this.trackTotalHits);
        if (this.timeout != null) {
            nativeSearchQuery.setTimeout(this.timeout);
        }
        return nativeSearchQuery;
    }
}

