/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Slice;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHitSupport;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchHitsIterator;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.MoreLikeThisQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.util.CloseableIterator;
import org.springframework.lang.Nullable;

public interface SearchOperations {
    default public long count(Query query, IndexCoordinates index) {
        return this.count(query, null, index);
    }

    public long count(Query var1, Class<?> var2);

    public long count(Query var1, @Nullable Class<?> var2, IndexCoordinates var3);

    @Deprecated
    default public <T> T queryForObject(Query query, Class<T> clazz, IndexCoordinates index) {
        return (T)SearchHitSupport.unwrapSearchHits(this.searchOne(query, clazz, index));
    }

    @Deprecated
    default public <T> AggregatedPage<T> queryForPage(Query query, Class<T> clazz, IndexCoordinates index) {
        SearchHits<T> searchHits = this.search(query, clazz, index);
        AggregatedPage<SearchHit<T>> aggregatedPage = SearchHitSupport.page(searchHits, query.getPageable());
        return (AggregatedPage)SearchHitSupport.unwrapSearchHits(aggregatedPage);
    }

    @Deprecated
    default public <T> List<Page<T>> queryForPage(List<? extends Query> queries, Class<T> clazz, IndexCoordinates index) {
        ArrayList pageList = new ArrayList();
        List<SearchHits<SearchHits>> searchHitsList = this.multiSearch(queries, clazz, index);
        Iterator<? extends Query> qit = queries.iterator();
        searchHitsList.forEach(searchHits -> {
            AggregatedPage aggregatedPage = SearchHitSupport.page(searchHits, ((Query)qit.next()).getPageable());
            Page page = (Page)SearchHitSupport.unwrapSearchHits(aggregatedPage);
            pageList.add(page);
        });
        return pageList;
    }

    @Deprecated
    default public List<AggregatedPage<?>> queryForPage(List<? extends Query> queries, List<Class<?>> classes, IndexCoordinates index) {
        ArrayList pageList = new ArrayList();
        List<SearchHits<?>> searchHitsList = this.multiSearch(queries, classes, index);
        Iterator<? extends Query> qit = queries.iterator();
        searchHitsList.forEach(searchHits -> {
            AggregatedPage aggregatedPage = SearchHitSupport.page(searchHits, ((Query)qit.next()).getPageable());
            AggregatedPage page = (AggregatedPage)SearchHitSupport.unwrapSearchHits(aggregatedPage);
            pageList.add(page);
        });
        return pageList;
    }

    @Deprecated
    public <T> CloseableIterator<T> stream(Query var1, Class<T> var2, IndexCoordinates var3);

    @Deprecated
    default public <T> List<T> queryForList(Query query, Class<T> clazz, IndexCoordinates index) {
        return (List)SearchHitSupport.unwrapSearchHits(this.search(query, clazz, index));
    }

    @Deprecated
    default public <T> List<List<T>> queryForList(List<Query> queries, Class<T> clazz, IndexCoordinates index) {
        return this.queryForPage(queries, clazz, index).stream().map(Slice::getContent).collect(Collectors.toList());
    }

    @Deprecated
    default public List<List<?>> queryForList(List<Query> queries, List<Class<?>> classes, IndexCoordinates index) {
        return this.queryForPage(queries, classes, index).stream().map(Slice::getContent).collect(Collectors.toList());
    }

    @Deprecated
    default public List<String> queryForIds(Query query, Class<?> clazz, IndexCoordinates index) {
        return this.search(query, clazz, index).map(SearchHit::getId).toList();
    }

    @Deprecated
    default public <T> AggregatedPage<T> moreLikeThis(MoreLikeThisQuery query, Class<T> clazz, IndexCoordinates index) {
        SearchHits<T> searchHits = this.search(query, clazz, index);
        AggregatedPage<SearchHit<T>> aggregatedPage = SearchHitSupport.page(searchHits, query.getPageable());
        return (AggregatedPage)SearchHitSupport.unwrapSearchHits(aggregatedPage);
    }

    public SearchResponse suggest(SuggestBuilder var1, Class<?> var2);

    public SearchResponse suggest(SuggestBuilder var1, IndexCoordinates var2);

    @Nullable
    default public <T> SearchHit<T> searchOne(Query query, Class<T> clazz) {
        List<SearchHit<T>> content = this.search(query, clazz).getSearchHits();
        return content.isEmpty() ? null : content.get(0);
    }

    @Nullable
    default public <T> SearchHit<T> searchOne(Query query, Class<T> clazz, IndexCoordinates index) {
        List<SearchHit<T>> content = this.search(query, clazz, index).getSearchHits();
        return content.isEmpty() ? null : content.get(0);
    }

    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> var1, Class<T> var2);

    public <T> List<SearchHits<T>> multiSearch(List<? extends Query> var1, Class<T> var2, IndexCoordinates var3);

    public List<SearchHits<?>> multiSearch(List<? extends Query> var1, List<Class<?>> var2);

    public List<SearchHits<?>> multiSearch(List<? extends Query> var1, List<Class<?>> var2, IndexCoordinates var3);

    public <T> SearchHits<T> search(Query var1, Class<T> var2);

    public <T> SearchHits<T> search(Query var1, Class<T> var2, IndexCoordinates var3);

    public <T> SearchHits<T> search(MoreLikeThisQuery var1, Class<T> var2);

    public <T> SearchHits<T> search(MoreLikeThisQuery var1, Class<T> var2, IndexCoordinates var3);

    public <T> SearchHitsIterator<T> searchForStream(Query var1, Class<T> var2);

    public <T> SearchHitsIterator<T> searchForStream(Query var1, Class<T> var2, IndexCoordinates var3);
}

