/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.mapping;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.index.VersionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Parent;
import org.springframework.data.elasticsearch.annotations.Setting;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleElasticsearchPersistentEntity<T>
extends BasicPersistentEntity<T, ElasticsearchPersistentProperty>
implements ElasticsearchPersistentEntity<T>,
ApplicationContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleElasticsearchPersistentEntity.class);
    private final StandardEvaluationContext context;
    private final SpelExpressionParser parser;
    @Nullable
    private String indexName;
    @Nullable
    private String indexType;
    private boolean useServerConfiguration;
    private short shards;
    private short replicas;
    @Nullable
    private String refreshInterval;
    @Nullable
    private String indexStoreType;
    @Nullable
    private String parentType;
    @Nullable
    private ElasticsearchPersistentProperty parentIdProperty;
    @Nullable
    private ElasticsearchPersistentProperty scoreProperty;
    @Nullable
    private ElasticsearchPersistentProperty seqNoPrimaryTermProperty;
    @Nullable
    private String settingPath;
    @Nullable
    private VersionType versionType;
    private boolean createIndexAndMapping;
    private final Map<String, ElasticsearchPersistentProperty> fieldNamePropertyCache = new ConcurrentHashMap<String, ElasticsearchPersistentProperty>();

    public SimpleElasticsearchPersistentEntity(TypeInformation<T> typeInformation) {
        super(typeInformation);
        this.context = new StandardEvaluationContext();
        this.parser = new SpelExpressionParser();
        Class clazz = typeInformation.getType();
        if (clazz.isAnnotationPresent(Document.class)) {
            Document document = clazz.getAnnotation(Document.class);
            Assert.hasText((String)document.indexName(), (String)" Unknown indexName. Make sure the indexName is defined. e.g @Document(indexName=\"foo\")");
            this.indexName = document.indexName();
            this.indexType = StringUtils.hasText((String)document.type()) ? document.type() : clazz.getSimpleName().toLowerCase(Locale.ENGLISH);
            this.useServerConfiguration = document.useServerConfiguration();
            this.shards = document.shards();
            this.replicas = document.replicas();
            this.refreshInterval = document.refreshInterval();
            this.indexStoreType = document.indexStoreType();
            this.versionType = document.versionType();
            this.createIndexAndMapping = document.createIndex();
        }
        if (clazz.isAnnotationPresent(Setting.class)) {
            this.settingPath = typeInformation.getType().getAnnotation(Setting.class).settingPath();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)applicationContext));
        this.context.setRootObject((Object)applicationContext);
    }

    private String getIndexName() {
        if (this.indexName != null) {
            Expression expression = this.parser.parseExpression(this.indexName, ParserContext.TEMPLATE_EXPRESSION);
            return (String)expression.getValue((EvaluationContext)this.context, String.class);
        }
        return this.getTypeInformation().getType().getSimpleName();
    }

    private String getIndexType() {
        if (this.indexType != null) {
            Expression expression = this.parser.parseExpression(this.indexType, ParserContext.TEMPLATE_EXPRESSION);
            return (String)expression.getValue((EvaluationContext)this.context, String.class);
        }
        return "";
    }

    @Override
    public IndexCoordinates getIndexCoordinates() {
        return IndexCoordinates.of(this.getIndexName()).withTypes(this.getIndexType());
    }

    @Override
    @Nullable
    public String getIndexStoreType() {
        return this.indexStoreType;
    }

    @Override
    public short getShards() {
        return this.shards;
    }

    @Override
    public short getReplicas() {
        return this.replicas;
    }

    @Override
    public boolean isUseServerConfiguration() {
        return this.useServerConfiguration;
    }

    @Override
    @Nullable
    public String getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    @Nullable
    public String getParentType() {
        return this.parentType;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getParentIdProperty() {
        return this.parentIdProperty;
    }

    @Override
    @Nullable
    public VersionType getVersionType() {
        return this.versionType;
    }

    @Override
    public String settingPath() {
        return this.settingPath;
    }

    @Override
    public boolean isCreateIndexAndMapping() {
        return this.createIndexAndMapping;
    }

    @Override
    public boolean hasScoreProperty() {
        return this.scoreProperty != null;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getScoreProperty() {
        return this.scoreProperty;
    }

    public void addPersistentProperty(ElasticsearchPersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
        if (property.isParentProperty()) {
            ElasticsearchPersistentProperty parentProperty = this.parentIdProperty;
            if (parentProperty != null) {
                throw new MappingException(String.format("Attempt to add parent property %s but already have property %s registered as parent property. Check your mapping configuration!", property.getField(), parentProperty.getField()));
            }
            Parent parentAnnotation = (Parent)property.findAnnotation(Parent.class);
            this.parentIdProperty = property;
            this.parentType = parentAnnotation.type();
        }
        if (property.isScoreProperty()) {
            ElasticsearchPersistentProperty scoreProperty = this.scoreProperty;
            if (scoreProperty != null) {
                throw new MappingException(String.format("Attempt to add score property %s but already have property %s registered as score property. Check your mapping configuration!", property.getField(), scoreProperty.getField()));
            }
            this.scoreProperty = property;
        }
        if (property.isSeqNoPrimaryTermProperty()) {
            ElasticsearchPersistentProperty seqNoPrimaryTermProperty = this.seqNoPrimaryTermProperty;
            if (seqNoPrimaryTermProperty != null) {
                throw new MappingException(String.format("Attempt to add SeqNoPrimaryTerm property %s but already have property %s registered as SeqNoPrimaryTerm property. Check your entity configuration!", property.getField(), seqNoPrimaryTermProperty.getField()));
            }
            this.seqNoPrimaryTermProperty = property;
            if (this.hasVersionProperty()) {
                this.warnAboutBothSeqNoPrimaryTermAndVersionProperties();
            }
        }
        if (property.isVersionProperty() && this.hasSeqNoPrimaryTermProperty()) {
            this.warnAboutBothSeqNoPrimaryTermAndVersionProperties();
        }
    }

    private void warnAboutBothSeqNoPrimaryTermAndVersionProperties() {
        LOGGER.warn("Both SeqNoPrimaryTerm and @Version properties are defined on {}. Version will not be sent in index requests when seq_no is sent!", (Object)this.getType());
    }

    public void setPersistentPropertyAccessorFactory(PersistentPropertyAccessorFactory factory) {
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getPersistentPropertyWithFieldName(String fieldName) {
        Assert.notNull((Object)fieldName, (String)"fieldName must not be null");
        return this.fieldNamePropertyCache.computeIfAbsent(fieldName, key -> {
            AtomicReference propertyRef = new AtomicReference();
            this.doWithProperties(property -> {
                if (key.equals(property.getFieldName())) {
                    propertyRef.set(property);
                }
            });
            return (ElasticsearchPersistentProperty)propertyRef.get();
        });
    }

    @Override
    public boolean hasSeqNoPrimaryTermProperty() {
        return this.seqNoPrimaryTermProperty != null;
    }

    @Override
    @Nullable
    public ElasticsearchPersistentProperty getSeqNoPrimaryTermProperty() {
        return this.seqNoPrimaryTermProperty;
    }
}

