/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.rest.RestStatus;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.elasticsearch.NoSuchIndexException;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ElasticsearchExceptionTranslator
implements PersistenceExceptionTranslator {
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (this.isSeqNoConflict(ex)) {
            return new OptimisticLockingFailureException("Cannot index a document due to seq_no+primary_term conflict", (Throwable)ex);
        }
        if (ex instanceof ElasticsearchException) {
            ElasticsearchException elasticsearchException = (ElasticsearchException)ex;
            if (!this.indexAvailable(elasticsearchException)) {
                return new NoSuchIndexException(ObjectUtils.nullSafeToString((Object)elasticsearchException.getMetadata("es.index")), ex);
            }
            return new UncategorizedElasticsearchException(ex.getMessage(), ex);
        }
        if (ex instanceof ValidationException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        Throwable cause = ex.getCause();
        if (cause instanceof IOException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        return null;
    }

    private boolean isSeqNoConflict(Exception exception) {
        if (exception instanceof ElasticsearchStatusException) {
            ElasticsearchStatusException statusException = (ElasticsearchStatusException)exception;
            return statusException.status() == RestStatus.CONFLICT && statusException.getMessage() != null && statusException.getMessage().contains("type=version_conflict_engine_exception") && statusException.getMessage().contains("version conflict, required seqNo");
        }
        if (exception instanceof VersionConflictEngineException) {
            VersionConflictEngineException versionConflictEngineException = (VersionConflictEngineException)exception;
            return versionConflictEngineException.getMessage() != null && versionConflictEngineException.getMessage().contains("version conflict, required seqNo");
        }
        return false;
    }

    private boolean indexAvailable(ElasticsearchException ex) {
        List metadata = ex.getMetadata("es.index_uuid");
        if (metadata == null) {
            if (ex instanceof ElasticsearchStatusException) {
                return StringUtils.hasText((String)ObjectUtils.nullSafeToString((Object)ex.getIndex()));
            }
            return false;
        }
        return !CollectionUtils.contains(metadata.iterator(), (Object)"_na_");
    }
}

