/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.lucene.queryparser.flexible.core.util.StringUtils;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.Field;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class CriteriaQueryProcessor {
    CriteriaQueryProcessor() {
    }

    QueryBuilder createQueryFromCriteria(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria must not be null");
        LinkedList<QueryBuilder> shouldQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustNotQueryBuilderList = new LinkedList<QueryBuilder>();
        LinkedList<QueryBuilder> mustQueryBuilderList = new LinkedList<QueryBuilder>();
        ListIterator<Criteria> chainIterator = criteria.getCriteriaChain().listIterator();
        QueryBuilder firstQuery = null;
        boolean negateFirstQuery = false;
        while (chainIterator.hasNext()) {
            Criteria chainedCriteria = chainIterator.next();
            QueryBuilder queryFragmentForCriteria = this.createQueryFragmentForCriteria(chainedCriteria);
            if (queryFragmentForCriteria == null) continue;
            if (firstQuery == null) {
                firstQuery = queryFragmentForCriteria;
                negateFirstQuery = chainedCriteria.isNegating();
                continue;
            }
            if (chainedCriteria.isOr()) {
                shouldQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            if (chainedCriteria.isNegating()) {
                mustNotQueryBuilderList.add(queryFragmentForCriteria);
                continue;
            }
            mustQueryBuilderList.add(queryFragmentForCriteria);
        }
        if (firstQuery != null) {
            if (!shouldQueryBuilderList.isEmpty() && mustNotQueryBuilderList.isEmpty() && mustQueryBuilderList.isEmpty()) {
                shouldQueryBuilderList.add(0, firstQuery);
            } else if (negateFirstQuery) {
                mustNotQueryBuilderList.add(0, firstQuery);
            } else {
                mustQueryBuilderList.add(0, firstQuery);
            }
        }
        BoolQueryBuilder query = null;
        if (!(shouldQueryBuilderList.isEmpty() && mustNotQueryBuilderList.isEmpty() && mustQueryBuilderList.isEmpty())) {
            query = QueryBuilders.boolQuery();
            for (QueryBuilder qb : shouldQueryBuilderList) {
                query.should(qb);
            }
            for (QueryBuilder qb : mustNotQueryBuilderList) {
                query.mustNot(qb);
            }
            for (QueryBuilder qb : mustQueryBuilderList) {
                query.must(qb);
            }
        }
        return query;
    }

    @Nullable
    private QueryBuilder createQueryFragmentForCriteria(Criteria chainedCriteria) {
        if (chainedCriteria.getQueryCriteriaEntries().isEmpty()) {
            return null;
        }
        Iterator<Criteria.CriteriaEntry> it = chainedCriteria.getQueryCriteriaEntries().iterator();
        boolean singeEntryCriteria = chainedCriteria.getQueryCriteriaEntries().size() == 1;
        Field field = chainedCriteria.getField();
        String fieldName = field.getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        BoolQueryBuilder query = null;
        if (singeEntryCriteria) {
            Criteria.CriteriaEntry entry = it.next();
            query = this.processCriteriaEntry(entry, field);
        } else {
            query = QueryBuilders.boolQuery();
            while (it.hasNext()) {
                Criteria.CriteriaEntry entry = it.next();
                query.must(this.processCriteriaEntry(entry, field));
            }
        }
        this.addBoost((QueryBuilder)query, chainedCriteria.getBoost());
        return query;
    }

    @Nullable
    private QueryBuilder processCriteriaEntry(Criteria.CriteriaEntry entry, Field field) {
        String fieldName = field.getName();
        boolean isKeywordField = FieldType.Keyword == field.getFieldType();
        Criteria.OperationKey key = entry.getKey();
        Object value = entry.getValue();
        if (value == null) {
            if (key == Criteria.OperationKey.EXISTS) {
                return QueryBuilders.existsQuery((String)fieldName);
            }
            return null;
        }
        String searchText = QueryParserUtil.escape((String)value.toString());
        Object query = null;
        switch (key) {
            case EQUALS: {
                query = QueryBuilders.queryStringQuery((String)searchText).field(fieldName).defaultOperator(Operator.AND);
                break;
            }
            case CONTAINS: {
                query = QueryBuilders.queryStringQuery((String)('*' + searchText + '*')).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case STARTS_WITH: {
                query = QueryBuilders.queryStringQuery((String)(searchText + '*')).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case ENDS_WITH: {
                query = QueryBuilders.queryStringQuery((String)('*' + searchText)).field(fieldName).analyzeWildcard(Boolean.valueOf(true));
                break;
            }
            case EXPRESSION: {
                query = QueryBuilders.queryStringQuery((String)value.toString()).field(fieldName);
                break;
            }
            case LESS_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).lte(value);
                break;
            }
            case GREATER_EQUAL: {
                query = QueryBuilders.rangeQuery((String)fieldName).gte(value);
                break;
            }
            case BETWEEN: {
                Object[] ranges = (Object[])value;
                query = QueryBuilders.rangeQuery((String)fieldName).from(ranges[0]).to(ranges[1]);
                break;
            }
            case LESS: {
                query = QueryBuilders.rangeQuery((String)fieldName).lt(value);
                break;
            }
            case GREATER: {
                query = QueryBuilders.rangeQuery((String)fieldName).gt(value);
                break;
            }
            case FUZZY: {
                query = QueryBuilders.fuzzyQuery((String)fieldName, (String)searchText);
                break;
            }
            case IN: {
                if (!(value instanceof Iterable)) break;
                Iterable iterable = (Iterable)value;
                if (isKeywordField) {
                    query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, CriteriaQueryProcessor.toStringList(iterable)));
                    break;
                }
                query = QueryBuilders.queryStringQuery((String)CriteriaQueryProcessor.orQueryString(iterable)).field(fieldName);
                break;
            }
            case NOT_IN: {
                if (!(value instanceof Iterable)) break;
                Iterable iterable = (Iterable)value;
                query = isKeywordField ? QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)fieldName, CriteriaQueryProcessor.toStringList(iterable))) : QueryBuilders.queryStringQuery((String)("NOT(" + CriteriaQueryProcessor.orQueryString(iterable) + ')')).field(fieldName);
            }
        }
        return query;
    }

    private static List<String> toStringList(Iterable<?> iterable) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object item : iterable) {
            list.add(StringUtils.toString(item));
        }
        return list;
    }

    private static String orQueryString(Iterable<?> iterable) {
        StringBuilder sb = new StringBuilder();
        for (Object item : iterable) {
            if (item == null) continue;
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('\"');
            sb.append(QueryParserUtil.escape((String)item.toString()));
            sb.append('\"');
        }
        return sb.toString();
    }

    private void addBoost(QueryBuilder query, float boost) {
        if (Float.isNaN(boost)) {
            return;
        }
        query.boost(boost);
    }
}

