/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.core.AbstractDefaultIndexOperations;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.AliasQuery;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultTransportIndexOperations
extends AbstractDefaultIndexOperations
implements IndexOperations {
    private final Client client;

    public DefaultTransportIndexOperations(Client client, ElasticsearchConverter elasticsearchConverter, Class<?> boundClass) {
        super(elasticsearchConverter, boundClass);
        this.client = client;
    }

    public DefaultTransportIndexOperations(Client client, ElasticsearchConverter elasticsearchConverter, IndexCoordinates boundIndex) {
        super(elasticsearchConverter, boundIndex);
        this.client = client;
    }

    @Override
    protected boolean doCreate(String indexName, @Nullable Document settings) {
        CreateIndexRequestBuilder createIndexRequestBuilder = this.requestFactory.createIndexRequestBuilder(this.client, indexName, settings);
        return ((CreateIndexResponse)createIndexRequestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    protected boolean doDelete(String indexName) {
        Assert.notNull((Object)indexName, (String)"No index defined for delete operation");
        if (this.doExists(indexName)) {
            return ((AcknowledgedResponse)this.client.admin().indices().delete(new DeleteIndexRequest(indexName)).actionGet()).isAcknowledged();
        }
        return false;
    }

    @Override
    protected boolean doExists(String indexName) {
        return ((IndicesExistsResponse)this.client.admin().indices().exists(Requests.indicesExistsRequest((String[])new String[]{indexName})).actionGet()).isExists();
    }

    @Override
    protected boolean doPutMapping(IndexCoordinates index, Document mapping) {
        Assert.notNull((Object)index, (String)"No index defined for putMapping()");
        PutMappingRequestBuilder requestBuilder = this.requestFactory.putMappingRequestBuilder(this.client, index, mapping);
        return ((AcknowledgedResponse)requestBuilder.execute().actionGet()).isAcknowledged();
    }

    @Override
    protected Map<String, Object> doGetMapping(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for getMapping()");
        try {
            return ((MappingMetaData)((ImmutableOpenMap)((GetMappingsResponse)this.client.admin().indices().getMappings((GetMappingsRequest)new GetMappingsRequest().indices(index.getIndexNames())).actionGet()).getMappings().get((Object)index.getIndexName())).get((Object)"_doc")).getSourceAsMap();
        }
        catch (Exception e) {
            throw new ElasticsearchException("Error while getting mapping for indexName : " + index.getIndexName(), e);
        }
    }

    @Override
    protected boolean doAddAlias(AliasQuery query, IndexCoordinates index) {
        IndicesAliasesRequest.AliasActions aliasAction = this.requestFactory.aliasAction(query, index);
        return ((AcknowledgedResponse)this.client.admin().indices().prepareAliases().addAliasAction(aliasAction).execute().actionGet()).isAcknowledged();
    }

    @Override
    protected boolean doRemoveAlias(AliasQuery query, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for Alias");
        Assert.notNull((Object)query.getAliasName(), (String)"No alias defined");
        return ((AcknowledgedResponse)this.client.admin().indices().prepareAliases().removeAlias(index.getIndexName(), query.getAliasName()).execute().actionGet()).isAcknowledged();
    }

    @Override
    protected List<AliasMetaData> doQueryForAlias(String indexName) {
        return (List)((GetAliasesResponse)this.client.admin().indices().getAliases(new GetAliasesRequest().indices(new String[]{indexName})).actionGet()).getAliases().get((Object)indexName);
    }

    @Override
    protected Map<String, Object> doGetSettings(String indexName, boolean includeDefaults) {
        Assert.notNull((Object)indexName, (String)"No index defined for getSettings");
        GetSettingsRequest request = new GetSettingsRequest().indices(new String[]{indexName}).includeDefaults(includeDefaults);
        GetSettingsResponse response = (GetSettingsResponse)this.client.admin().indices().getSettings(request).actionGet();
        return this.convertSettingsResponseToMap(response, indexName);
    }

    @Override
    protected void doRefresh(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"No index defined for refresh()");
        this.client.admin().indices().refresh(Requests.refreshRequest((String[])index.getIndexNames())).actionGet();
    }
}

