/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoAction;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequest;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.suggest.SuggestBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.elasticsearch.core.AbstractElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.DefaultTransportIndexOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchExceptionTranslator;
import org.springframework.data.elasticsearch.core.IndexOperations;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.document.Document;
import org.springframework.data.elasticsearch.core.document.DocumentAdapters;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.BulkOptions;
import org.springframework.data.elasticsearch.core.query.DeleteQuery;
import org.springframework.data.elasticsearch.core.query.IndexQuery;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.UpdateQuery;
import org.springframework.data.elasticsearch.core.query.UpdateResponse;
import org.springframework.data.elasticsearch.support.SearchHitsUtil;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Deprecated
public class ElasticsearchTemplate
extends AbstractElasticsearchTemplate {
    private static final Logger QUERY_LOGGER = LoggerFactory.getLogger((String)"org.springframework.data.elasticsearch.core.QUERY");
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchTemplate.class);
    private Client client;
    @Nullable
    private String searchTimeout;
    private final ElasticsearchExceptionTranslator exceptionTranslator = new ElasticsearchExceptionTranslator();

    public ElasticsearchTemplate(Client client) {
        this.client = client;
        this.initialize(client, this.createElasticsearchConverter());
    }

    public ElasticsearchTemplate(Client client, ElasticsearchConverter elasticsearchConverter) {
        this.client = client;
        this.initialize(client, elasticsearchConverter);
    }

    private void initialize(Client client, ElasticsearchConverter elasticsearchConverter) {
        Assert.notNull((Object)client, (String)"Client must not be null!");
        this.client = client;
        this.initialize(elasticsearchConverter);
    }

    @Override
    public IndexOperations indexOps(Class<?> clazz) {
        Assert.notNull(clazz, (String)"clazz must not be null");
        return new DefaultTransportIndexOperations(this.client, this.elasticsearchConverter, clazz);
    }

    @Override
    public IndexOperations indexOps(IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        return new DefaultTransportIndexOperations(this.client, this.elasticsearchConverter, index);
    }

    @Nullable
    public String getSearchTimeout() {
        return this.searchTimeout;
    }

    public void setSearchTimeout(String searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    @Override
    public String index(IndexQuery query, IndexCoordinates index) {
        IndexResponse response;
        this.maybeCallbackBeforeConvertWithQuery(query, index);
        IndexRequestBuilder indexRequestBuilder = this.requestFactory.indexRequestBuilder(this.client, query, index);
        ActionFuture future = indexRequestBuilder.execute();
        try {
            response = (IndexResponse)future.actionGet();
        }
        catch (RuntimeException e) {
            throw this.translateException(e);
        }
        String documentId = response.getId();
        Object queryObject = query.getObject();
        if (queryObject != null) {
            this.setPersistentEntityId(queryObject, documentId);
        }
        this.maybeCallbackAfterSaveWithQuery(query, index);
        return documentId;
    }

    @Override
    @Nullable
    public <T> T get(String id, Class<T> clazz, IndexCoordinates index) {
        GetRequestBuilder getRequestBuilder = this.requestFactory.getRequestBuilder(this.client, id, index);
        GetResponse response = (GetResponse)getRequestBuilder.execute().actionGet();
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> callback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this, this.elasticsearchConverter, clazz, index);
        return callback.doWith(DocumentAdapters.from(response));
    }

    @Override
    public <T> List<T> multiGet(Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)index, (String)"index must not be null");
        Assert.notEmpty(query.getIds(), (String)"No Ids defined for Query");
        MultiGetRequestBuilder builder = this.requestFactory.multiGetRequestBuilder(this.client, query, index);
        AbstractElasticsearchTemplate.ReadDocumentCallback<T> callback = new AbstractElasticsearchTemplate.ReadDocumentCallback<T>(this, this.elasticsearchConverter, clazz, index);
        List<Document> documents = DocumentAdapters.from((MultiGetResponse)builder.execute().actionGet());
        return documents.stream().map(callback::doWith).collect(Collectors.toList());
    }

    @Override
    protected boolean doExists(String id, IndexCoordinates index) {
        GetRequestBuilder getRequestBuilder = this.requestFactory.getRequestBuilder(this.client, id, index);
        getRequestBuilder.setFetchSource(false);
        return ((GetResponse)getRequestBuilder.execute().actionGet()).isExists();
    }

    @Override
    public List<String> bulkIndex(List<IndexQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of IndexQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        List<String> ids = this.doBulkOperation(queries, bulkOptions, index);
        this.maybeCallbackAfterSaveWithQueries(queries, index);
        return ids;
    }

    @Override
    public void bulkUpdate(List<UpdateQuery> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        Assert.notNull(queries, (String)"List of UpdateQuery must not be null");
        Assert.notNull((Object)bulkOptions, (String)"BulkOptions must not be null");
        this.doBulkOperation(queries, bulkOptions, index);
    }

    @Override
    public String delete(String id, IndexCoordinates index) {
        Assert.notNull((Object)id, (String)"id must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        return ((DeleteResponse)this.client.prepareDelete(index.getIndexName(), "_doc", this.elasticsearchConverter.convertId(id)).execute().actionGet()).getId();
    }

    @Override
    @Deprecated
    public void delete(DeleteQuery deleteQuery, IndexCoordinates index) {
        this.requestFactory.deleteByQueryRequestBuilder(this.client, deleteQuery, index).get();
    }

    @Override
    public void delete(Query query, Class<?> clazz, IndexCoordinates index) {
        this.requestFactory.deleteByQueryRequestBuilder(this.client, query, clazz, index).get();
    }

    @Override
    public String delete(Object entity, IndexCoordinates index) {
        return super.delete(entity, index);
    }

    @Override
    public UpdateResponse update(UpdateQuery query, IndexCoordinates index) {
        UpdateRequestBuilder updateRequestBuilder = this.requestFactory.updateRequestBuilderFor(this.client, query, index);
        org.elasticsearch.action.update.UpdateResponse updateResponse = (org.elasticsearch.action.update.UpdateResponse)updateRequestBuilder.execute().actionGet();
        UpdateResponse.Result result = UpdateResponse.Result.valueOf(updateResponse.getResult().name());
        return new UpdateResponse(result);
    }

    private List<String> doBulkOperation(List<?> queries, BulkOptions bulkOptions, IndexCoordinates index) {
        this.maybeCallbackBeforeConvertWithQueries(queries, index);
        BulkRequestBuilder bulkRequest = this.requestFactory.bulkRequestBuilder(this.client, queries, bulkOptions, index);
        return this.checkForBulkOperationFailure((BulkResponse)bulkRequest.execute().actionGet());
    }

    @Override
    public long count(Query query, @Nullable Class<?> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query, (String)"query must not be null");
        Assert.notNull((Object)index, (String)"index must not be null");
        boolean trackTotalHits = query.getTrackTotalHits();
        query.setTrackTotalHits(true);
        SearchRequestBuilder searchRequestBuilder = this.requestFactory.searchRequestBuilder(this.client, query, clazz, index);
        query.setTrackTotalHits(trackTotalHits);
        searchRequestBuilder.setSize(0);
        return SearchHitsUtil.getTotalCount(this.getSearchResponse(searchRequestBuilder).getHits());
    }

    @Override
    public <T> SearchHits<T> search(Query query, Class<T> clazz, IndexCoordinates index) {
        SearchRequestBuilder searchRequestBuilder = this.requestFactory.searchRequestBuilder(this.client, query, clazz, index);
        SearchResponse response = this.getSearchResponse(searchRequestBuilder);
        AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchDocumentResponseCallback<T>(this, clazz, index);
        return (SearchHits)callback.doWith(SearchDocumentResponse.from(response));
    }

    @Override
    public <T> SearchScrollHits<T> searchScrollStart(long scrollTimeInMillis, Query query, Class<T> clazz, IndexCoordinates index) {
        Assert.notNull((Object)query.getPageable(), (String)"pageable of query must not be null.");
        ActionFuture action = this.requestFactory.searchRequestBuilder(this.client, query, clazz, index).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute();
        SearchResponse response = this.getSearchResponseWithTimeout((ActionFuture<SearchResponse>)action);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T>(this, clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponse.from(response));
    }

    @Override
    public <T> SearchScrollHits<T> searchScrollContinue(@Nullable String scrollId, long scrollTimeInMillis, Class<T> clazz, IndexCoordinates index) {
        ActionFuture action = this.client.prepareSearchScroll(scrollId).setScroll(TimeValue.timeValueMillis((long)scrollTimeInMillis)).execute();
        SearchResponse response = this.getSearchResponseWithTimeout((ActionFuture<SearchResponse>)action);
        AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T> callback = new AbstractElasticsearchTemplate.ReadSearchScrollDocumentResponseCallback<T>(this, clazz, index);
        return (SearchScrollHits)callback.doWith(SearchDocumentResponse.from(response));
    }

    @Override
    public void searchScrollClear(List<String> scrollIds) {
        try {
            this.client.prepareClearScroll().setScrollIds(scrollIds).execute().actionGet();
        }
        catch (Exception e) {
            LOGGER.warn("Could not clear scroll: {}", (Object)e.getMessage());
        }
    }

    @Override
    public SearchResponse suggest(SuggestBuilder suggestion, IndexCoordinates index) {
        return (SearchResponse)this.client.prepareSearch(index.getIndexNames()).suggest(suggestion).get();
    }

    @Override
    protected MultiSearchResponse.Item[] getMultiSearchResult(MultiSearchRequest request) {
        ActionFuture future = this.client.multiSearch(request);
        MultiSearchResponse response = (MultiSearchResponse)future.actionGet();
        MultiSearchResponse.Item[] items = response.getResponses();
        Assert.isTrue((items.length == request.requests().size() ? 1 : 0) != 0, (String)"Response should have same length with queries");
        return items;
    }

    private SearchResponse getSearchResponse(SearchRequestBuilder requestBuilder) {
        if (QUERY_LOGGER.isDebugEnabled()) {
            QUERY_LOGGER.debug(requestBuilder.toString());
        }
        return this.getSearchResponseWithTimeout((ActionFuture<SearchResponse>)requestBuilder.execute());
    }

    private SearchResponse getSearchResponseWithTimeout(ActionFuture<SearchResponse> response) {
        return this.searchTimeout == null ? (SearchResponse)response.actionGet() : (SearchResponse)response.actionGet(this.searchTimeout);
    }

    @Override
    protected String getClusterVersion() {
        try {
            NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)this.client.admin().cluster().nodesInfo((NodesInfoRequest)new NodesInfoRequestBuilder((ElasticsearchClient)this.client, NodesInfoAction.INSTANCE).request()).actionGet();
            if (!nodesInfoResponse.getNodes().isEmpty()) {
                return ((NodeInfo)nodesInfoResponse.getNodes().get(0)).getVersion().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Client getClient() {
        return this.client;
    }

    private RuntimeException translateException(Exception exception) {
        RuntimeException runtimeException = exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception.getMessage(), exception);
        DataAccessException potentiallyTranslatedException = this.exceptionTranslator.translateExceptionIfPossible(runtimeException);
        return potentiallyTranslatedException != null ? potentiallyTranslatedException : runtimeException;
    }
}

