/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.core.query.SourceFilter;
import org.springframework.util.Assert;

abstract class AbstractQuery
implements Query {
    protected Pageable pageable = DEFAULT_PAGE;
    protected Sort sort;
    protected List<String> indices = new ArrayList<String>();
    protected List<String> types = new ArrayList<String>();
    protected List<String> fields = new ArrayList<String>();
    protected SourceFilter sourceFilter;
    protected float minScore;
    protected Collection<String> ids;
    protected String route;
    protected SearchType searchType = SearchType.DFS_QUERY_THEN_FETCH;
    protected IndicesOptions indicesOptions;
    protected boolean trackScores;
    protected String preference;

    AbstractQuery() {
    }

    @Override
    public Sort getSort() {
        return this.sort;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public final <T extends Query> T setPageable(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
        this.pageable = pageable;
        return this.addSort(pageable.getSort());
    }

    @Override
    public void addFields(String ... fields) {
        Collections.addAll(this.fields, fields);
    }

    @Override
    public List<String> getFields() {
        return this.fields;
    }

    @Override
    public List<String> getIndices() {
        return this.indices;
    }

    @Override
    public void addIndices(String ... indices) {
        Collections.addAll(this.indices, indices);
    }

    @Override
    public void addTypes(String ... types) {
        Collections.addAll(this.types, types);
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public void addSourceFilter(SourceFilter sourceFilter) {
        this.sourceFilter = sourceFilter;
    }

    @Override
    public SourceFilter getSourceFilter() {
        return this.sourceFilter;
    }

    @Override
    public final <T extends Query> T addSort(Sort sort) {
        if (sort == null) {
            return (T)this;
        }
        this.sort = this.sort == null ? sort : this.sort.and(sort);
        return (T)this;
    }

    @Override
    public float getMinScore() {
        return this.minScore;
    }

    public void setMinScore(float minScore) {
        this.minScore = minScore;
    }

    @Override
    public Collection<String> getIds() {
        return this.ids;
    }

    public void setIds(Collection<String> ids) {
        this.ids = ids;
    }

    @Override
    public String getRoute() {
        return this.route;
    }

    public void setRoute(String route) {
        this.route = route;
    }

    public void setSearchType(SearchType searchType) {
        this.searchType = searchType;
    }

    @Override
    public SearchType getSearchType() {
        return this.searchType;
    }

    @Override
    public IndicesOptions getIndicesOptions() {
        return this.indicesOptions;
    }

    public void setIndicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
    }

    @Override
    public boolean getTrackScores() {
        return this.trackScores;
    }

    public void setTrackScores(boolean trackScores) {
        this.trackScores = trackScores;
    }

    @Override
    public String getPreference() {
        return this.preference;
    }

    @Override
    public void setPreference(String preference) {
        this.preference = preference;
    }
}

