/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.springframework.data.elasticsearch.client.ClientConfigurationBuilder;
import org.springframework.http.HttpHeaders;

public interface ClientConfiguration {
    public static ClientConfigurationBuilderWithRequiredEndpoint builder() {
        return new ClientConfigurationBuilder();
    }

    public static ClientConfiguration localhost() {
        return new ClientConfigurationBuilder().connectedToLocalhost().build();
    }

    public static ClientConfiguration create(String hostAndPort) {
        return new ClientConfigurationBuilder().connectedTo(hostAndPort).build();
    }

    public static ClientConfiguration create(InetSocketAddress socketAddress) {
        return new ClientConfigurationBuilder().connectedTo(socketAddress).build();
    }

    public List<InetSocketAddress> getEndpoints();

    public HttpHeaders getDefaultHeaders();

    public boolean useSsl();

    public Optional<SSLContext> getSslContext();

    public Optional<HostnameVerifier> getHostNameVerifier();

    public Duration getConnectTimeout();

    public Duration getSocketTimeout();

    public Optional<String> getProxy();

    public static interface TerminalClientConfigurationBuilder {
        public TerminalClientConfigurationBuilder withDefaultHeaders(HttpHeaders var1);

        default public TerminalClientConfigurationBuilder withConnectTimeout(long millis) {
            return this.withConnectTimeout(Duration.ofMillis(millis));
        }

        public TerminalClientConfigurationBuilder withConnectTimeout(Duration var1);

        default public TerminalClientConfigurationBuilder withSocketTimeout(long millis) {
            return this.withSocketTimeout(Duration.ofMillis(millis));
        }

        public TerminalClientConfigurationBuilder withSocketTimeout(Duration var1);

        public TerminalClientConfigurationBuilder withBasicAuth(String var1, String var2);

        public MaybeSecureClientConfigurationBuilder withProxy(String var1);

        public ClientConfiguration build();
    }

    public static interface MaybeSecureClientConfigurationBuilder
    extends TerminalClientConfigurationBuilder {
        public TerminalClientConfigurationBuilder usingSsl();

        public TerminalClientConfigurationBuilder usingSsl(SSLContext var1);

        public TerminalClientConfigurationBuilder usingSsl(SSLContext var1, HostnameVerifier var2);
    }

    public static interface ClientConfigurationBuilderWithRequiredEndpoint {
        default public MaybeSecureClientConfigurationBuilder connectedTo(String hostAndPort) {
            return this.connectedTo(new String[]{hostAndPort});
        }

        public MaybeSecureClientConfigurationBuilder connectedTo(String ... var1);

        default public MaybeSecureClientConfigurationBuilder connectedTo(InetSocketAddress endpoint) {
            return this.connectedTo(new InetSocketAddress[]{endpoint});
        }

        public MaybeSecureClientConfigurationBuilder connectedTo(InetSocketAddress ... var1);

        default public MaybeSecureClientConfigurationBuilder connectedToLocalhost() {
            return this.connectedTo("localhost:9200");
        }
    }
}

