/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.support;

import org.reactivestreams.Publisher;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.data.elasticsearch.repository.ReactiveElasticsearchRepository;
import org.springframework.data.elasticsearch.repository.support.ElasticsearchEntityInformation;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveElasticsearchRepository<T, ID>
implements ReactiveElasticsearchRepository<T, ID> {
    private final ElasticsearchEntityInformation<T, ID> entityInformation;
    private final ReactiveElasticsearchOperations elasticsearchOperations;

    public SimpleReactiveElasticsearchRepository(ElasticsearchEntityInformation<T, ID> entityInformation, ReactiveElasticsearchOperations elasticsearchOperations) {
        Assert.notNull(entityInformation, (String)"EntityInformation must not be null!");
        Assert.notNull((Object)elasticsearchOperations, (String)"ElasticsearchOperations must not be null!");
        this.entityInformation = entityInformation;
        this.elasticsearchOperations = elasticsearchOperations;
    }

    public Flux<T> findAll(Sort sort) {
        return this.elasticsearchOperations.find((Query)Query.findAll().addSort(sort), this.entityInformation.getJavaType(), this.entityInformation.getIndexName(), this.entityInformation.getType());
    }

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.elasticsearchOperations.save(entity, this.entityInformation.getIndexName(), this.entityInformation.getType());
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.saveAll((Publisher<S>)Flux.fromIterable(entities));
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.elasticsearchOperations.findById(this.convertId(id), this.entityInformation.getJavaType(), this.entityInformation.getIndexName(), this.entityInformation.getType());
    }

    public Mono<T> findById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.elasticsearchOperations.exists(this.convertId(id), this.entityInformation.getJavaType(), this.entityInformation.getIndexName(), this.entityInformation.getType());
    }

    public Mono<Boolean> existsById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::existsById);
    }

    public Flux<T> findAll() {
        return this.elasticsearchOperations.find(Query.findAll(), this.entityInformation.getJavaType(), this.entityInformation.getIndexName(), this.entityInformation.getType());
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        return Flux.fromIterable(ids).flatMap(this::findById);
    }

    public Flux<T> findAllById(Publisher<ID> idStream) {
        Assert.notNull(idStream, (String)"IdStream must not be null!");
        return Flux.from(idStream).buffer().flatMap(this::findAllById);
    }

    public Mono<Long> count() {
        return this.elasticsearchOperations.count(Query.findAll(), this.entityInformation.getJavaType(), this.entityInformation.getIndexName(), this.entityInformation.getType());
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.elasticsearchOperations.deleteById(this.convertId(id), this.entityInformation.getJavaType(), this.entityInformation.getIndexName(), this.entityInformation.getType()).then();
    }

    public Mono<Void> deleteById(Publisher<ID> id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return Mono.from(id).flatMap(this::deleteById);
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.elasticsearchOperations.delete(entity, this.entityInformation.getIndexName(), this.entityInformation.getType()).then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"Entities must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(entities));
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"EntityStream must not be null!");
        return Flux.from(entityStream).flatMap(this::delete).then();
    }

    public Mono<Void> deleteAll() {
        return this.elasticsearchOperations.deleteBy(Query.findAll(), this.entityInformation.getJavaType(), this.entityInformation.getIndexName(), this.entityInformation.getType()).then();
    }

    private String convertId(Object id) {
        return this.elasticsearchOperations.getElasticsearchConverter().convertId(id);
    }
}

