/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.NestedField;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;

class MappingBuilder {
    public static final String FIELD_STORE = "store";
    public static final String FIELD_TYPE = "type";
    public static final String FIELD_INDEX = "index";
    public static final String FIELD_FORMAT = "format";
    public static final String FIELD_SEARCH_ANALYZER = "search_analyzer";
    public static final String FIELD_INDEX_ANALYZER = "index_analyzer";
    public static final String FIELD_PROPERTIES = "properties";
    public static final String FIELD_PARENT = "_parent";
    public static final String INDEX_VALUE_NOT_ANALYZED = "not_analyzed";
    public static final String TYPE_VALUE_STRING = "string";
    public static final String TYPE_VALUE_GEO_POINT = "geo_point";
    private static SimpleTypeHolder SIMPLE_TYPE_HOLDER = new SimpleTypeHolder();

    MappingBuilder() {
    }

    static XContentBuilder buildMapping(Class clazz, String indexType, String idFieldName, String parentType) throws IOException {
        XContentBuilder mapping = XContentFactory.jsonBuilder().startObject().startObject(indexType);
        if (org.springframework.util.StringUtils.hasText((String)parentType)) {
            mapping.startObject(FIELD_PARENT).field(FIELD_TYPE, parentType).endObject();
        }
        XContentBuilder xContentBuilder = mapping.startObject(FIELD_PROPERTIES);
        MappingBuilder.mapEntity(xContentBuilder, clazz, true, idFieldName, "", false, FieldType.Auto);
        return xContentBuilder.endObject().endObject().endObject();
    }

    private static void mapEntity(XContentBuilder xContentBuilder, Class clazz, boolean isRootObject, String idFieldName, String nestedObjectFieldName, boolean nestedOrObjectField, FieldType fieldType) throws IOException {
        java.lang.reflect.Field[] fields = clazz.getDeclaredFields();
        if (!isRootObject && (MappingBuilder.isAnyPropertyAnnotatedAsField(fields) || nestedOrObjectField)) {
            String type = FieldType.Object.toString().toLowerCase();
            if (nestedOrObjectField) {
                type = fieldType.toString().toLowerCase();
            }
            xContentBuilder.startObject(nestedObjectFieldName).field(FIELD_TYPE, type).startObject(FIELD_PROPERTIES);
        }
        for (java.lang.reflect.Field field : fields) {
            if (field.isAnnotationPresent(Transient.class) || MappingBuilder.isInIgnoreFields(field)) continue;
            boolean isGeoField = MappingBuilder.isGeoField(field);
            Field singleField = field.getAnnotation(Field.class);
            if (!isGeoField && MappingBuilder.isEntity(field) && MappingBuilder.isAnnotated(field)) {
                if (singleField == null) continue;
                boolean nestedOrObject = MappingBuilder.isNestedOrObjectField(field);
                MappingBuilder.mapEntity(xContentBuilder, MappingBuilder.getFieldType(field), false, "", field.getName(), nestedOrObject, singleField.type());
                if (nestedOrObject) continue;
            }
            MultiField multiField = field.getAnnotation(MultiField.class);
            if (isGeoField) {
                MappingBuilder.applyGeoPointFieldMapping(xContentBuilder, field);
            }
            if (isRootObject && singleField != null && MappingBuilder.isIdField(field, idFieldName)) {
                MappingBuilder.applyDefaultIdFieldMapping(xContentBuilder, field);
                continue;
            }
            if (multiField != null) {
                MappingBuilder.addMultiFieldMapping(xContentBuilder, field, multiField);
                continue;
            }
            if (singleField == null) continue;
            MappingBuilder.addSingleFieldMapping(xContentBuilder, field, singleField);
        }
        if (!isRootObject && MappingBuilder.isAnyPropertyAnnotatedAsField(fields) || nestedOrObjectField) {
            xContentBuilder.endObject().endObject();
        }
    }

    private static boolean isAnnotated(java.lang.reflect.Field field) {
        return field.getAnnotation(Field.class) != null || field.getAnnotation(MultiField.class) != null || field.getAnnotation(GeoPointField.class) != null;
    }

    private static void applyGeoPointFieldMapping(XContentBuilder xContentBuilder, java.lang.reflect.Field field) throws IOException {
        xContentBuilder.startObject(field.getName());
        xContentBuilder.field(FIELD_TYPE, TYPE_VALUE_GEO_POINT).endObject();
    }

    private static void applyDefaultIdFieldMapping(XContentBuilder xContentBuilder, java.lang.reflect.Field field) throws IOException {
        xContentBuilder.startObject(field.getName()).field(FIELD_TYPE, TYPE_VALUE_STRING).field(FIELD_INDEX, INDEX_VALUE_NOT_ANALYZED);
        xContentBuilder.endObject();
    }

    private static void addSingleFieldMapping(XContentBuilder xContentBuilder, java.lang.reflect.Field field, Field fieldAnnotation) throws IOException {
        xContentBuilder.startObject(field.getName());
        xContentBuilder.field(FIELD_STORE, fieldAnnotation.store());
        if (FieldType.Auto != fieldAnnotation.type()) {
            xContentBuilder.field(FIELD_TYPE, fieldAnnotation.type().name().toLowerCase());
            if (FieldType.Date == fieldAnnotation.type() && DateFormat.none != fieldAnnotation.format()) {
                xContentBuilder.field(FIELD_FORMAT, DateFormat.custom == fieldAnnotation.format() ? fieldAnnotation.pattern() : fieldAnnotation.format());
            }
        }
        if (FieldIndex.not_analyzed == fieldAnnotation.index()) {
            xContentBuilder.field(FIELD_INDEX, fieldAnnotation.index().name().toLowerCase());
        }
        if (StringUtils.isNotBlank((String)fieldAnnotation.searchAnalyzer())) {
            xContentBuilder.field(FIELD_SEARCH_ANALYZER, fieldAnnotation.searchAnalyzer());
        }
        if (StringUtils.isNotBlank((String)fieldAnnotation.indexAnalyzer())) {
            xContentBuilder.field(FIELD_INDEX_ANALYZER, fieldAnnotation.indexAnalyzer());
        }
        xContentBuilder.endObject();
    }

    private static void addNestedFieldMapping(XContentBuilder builder, java.lang.reflect.Field field, NestedField annotation) throws IOException {
        builder.startObject(field.getName() + "." + annotation.dotSuffix());
        builder.field(FIELD_STORE, annotation.store());
        if (FieldType.Auto != annotation.type()) {
            builder.field(FIELD_TYPE, annotation.type().name().toLowerCase());
        }
        if (FieldIndex.not_analyzed == annotation.index()) {
            builder.field(FIELD_INDEX, annotation.index().name().toLowerCase());
        }
        if (StringUtils.isNotBlank((String)annotation.searchAnalyzer())) {
            builder.field(FIELD_SEARCH_ANALYZER, annotation.searchAnalyzer());
        }
        if (StringUtils.isNotBlank((String)annotation.indexAnalyzer())) {
            builder.field(FIELD_INDEX_ANALYZER, annotation.indexAnalyzer());
        }
        builder.endObject();
    }

    private static void addMultiFieldMapping(XContentBuilder builder, java.lang.reflect.Field field, MultiField annotation) throws IOException {
        builder.startObject(field.getName());
        builder.field(FIELD_TYPE, "multi_field");
        builder.startObject("fields");
        MappingBuilder.addSingleFieldMapping(builder, field, annotation.mainField());
        for (NestedField nestedField : annotation.otherFields()) {
            MappingBuilder.addNestedFieldMapping(builder, field, nestedField);
        }
        builder.endObject();
        builder.endObject();
    }

    private static void addFacetMapping(XContentBuilder builder, java.lang.reflect.Field field, Field annotation) throws IOException {
        builder.startObject("untouched").field(FIELD_TYPE, TYPE_VALUE_STRING).field(FIELD_INDEX, INDEX_VALUE_NOT_ANALYZED).field(FIELD_STORE, true);
        builder.endObject();
    }

    private static void addSortMapping(XContentBuilder builder, java.lang.reflect.Field field, Field annotation) throws IOException {
        builder.startObject("sort").field(FIELD_TYPE, TYPE_VALUE_STRING).field(FIELD_INDEX, "keyword").field(FIELD_STORE, true);
        builder.endObject();
    }

    protected static boolean isEntity(java.lang.reflect.Field field) {
        ClassTypeInformation typeInformation = ClassTypeInformation.from(field.getType());
        Class<?> clazz = MappingBuilder.getFieldType(field);
        boolean isComplexType = !SIMPLE_TYPE_HOLDER.isSimpleType(clazz);
        return isComplexType && !Map.class.isAssignableFrom(typeInformation.getType());
    }

    protected static Class<?> getFieldType(java.lang.reflect.Field field) {
        Class clazz = field.getType();
        ClassTypeInformation typeInformation = ClassTypeInformation.from(clazz);
        if (typeInformation.isCollectionLike()) {
            clazz = GenericCollectionTypeResolver.getCollectionFieldType((java.lang.reflect.Field)field) != null ? GenericCollectionTypeResolver.getCollectionFieldType((java.lang.reflect.Field)field) : typeInformation.getComponentType().getType();
        }
        return clazz;
    }

    private static boolean isAnyPropertyAnnotatedAsField(java.lang.reflect.Field[] fields) {
        if (fields != null) {
            for (java.lang.reflect.Field field : fields) {
                if (!field.isAnnotationPresent(Field.class)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isIdField(java.lang.reflect.Field field, String idFieldName) {
        return idFieldName.equals(field.getName());
    }

    private static boolean isInIgnoreFields(java.lang.reflect.Field field) {
        Field fieldAnnotation = field.getAnnotation(Field.class);
        if (null != fieldAnnotation) {
            String[] ignoreFields = fieldAnnotation.ignoreFields();
            return Arrays.asList(ignoreFields).contains(field.getName());
        }
        return false;
    }

    private static boolean isNestedOrObjectField(java.lang.reflect.Field field) {
        Field fieldAnnotation = field.getAnnotation(Field.class);
        return fieldAnnotation != null && (FieldType.Nested == fieldAnnotation.type() || FieldType.Object == fieldAnnotation.type());
    }

    private static boolean isGeoField(java.lang.reflect.Field field) {
        return field.getType() == GeoPoint.class || field.getAnnotation(GeoPointField.class) != null;
    }
}

