/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonValue;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.PartTreeN1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.support.N1qlQueryCreatorUtils;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class OldN1qlQueryCreator
extends AbstractQueryCreator<N1QLExpression, N1QLExpression>
implements PartTreeN1qlQueryCreator {
    private final N1QLExpression selectFrom;
    private final CouchbaseConverter converter;
    private final CouchbaseQueryMethod queryMethod;
    private final ParameterAccessor accessor;
    private final JsonArray placeHolderValues;
    private final AtomicInteger position;

    public OldN1qlQueryCreator(PartTree tree, ParameterAccessor parameters, N1QLExpression selectFrom, CouchbaseConverter converter, CouchbaseQueryMethod queryMethod) {
        super(tree, parameters);
        this.selectFrom = selectFrom;
        this.converter = converter;
        this.queryMethod = queryMethod;
        this.accessor = parameters;
        this.placeHolderValues = JsonArray.create();
        this.position = new AtomicInteger(1);
    }

    protected N1QLExpression create(Part part, Iterator<Object> iterator) {
        return N1qlQueryCreatorUtils.prepareExpression(this.converter, part, iterator, this.position, this.placeHolderValues);
    }

    protected N1QLExpression and(Part part, N1QLExpression base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        return base.and((N1QLExpression)this.create(part, (Iterator)iterator));
    }

    protected N1QLExpression or(N1QLExpression base, N1QLExpression criteria) {
        return base.or(criteria);
    }

    protected N1QLExpression complete(N1QLExpression criteria, Sort sort) {
        N1QLExpression selectFromWhere;
        N1QLExpression whereCriteria = N1qlUtils.createWhereFilterForEntity(criteria, this.converter, this.queryMethod.getEntityInformation());
        N1QLExpression n1QLExpression = selectFromWhere = whereCriteria != null ? this.selectFrom.where(whereCriteria) : this.selectFrom;
        if ((this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) && this.accessor.getPageable().isPaged()) {
            Pageable pageable = this.accessor.getPageable();
            sort = pageable.getSort();
        }
        if (sort.isSorted()) {
            N1QLExpression[] cbSorts = N1qlUtils.createSort(sort);
            return selectFromWhere.orderBy(cbSorts);
        }
        return selectFromWhere;
    }

    @Override
    public JsonValue getPlaceHolderValues() {
        return this.placeHolderValues;
    }
}

