/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.error.BucketNotFoundException;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CollectionNotFoundException;
import com.couchbase.client.core.error.ConfigException;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.DesignDocumentNotFoundException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentLockedException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.DurabilityAmbiguousException;
import com.couchbase.client.core.error.DurabilityImpossibleException;
import com.couchbase.client.core.error.DurabilityLevelNotAvailableException;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.error.ReplicaNotConfiguredException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.ScopeNotFoundException;
import com.couchbase.client.core.error.ServiceNotAvailableException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.error.ValueTooLargeException;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeoutException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.couchbase.core.OperationCancellationException;

public class CouchbaseExceptionTranslator
implements PersistenceExceptionTranslator {
    public final DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        if (ex instanceof ConfigException || ex instanceof ServiceNotAvailableException || ex instanceof CollectionNotFoundException || ex instanceof ScopeNotFoundException || ex instanceof BucketNotFoundException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof DocumentExistsException) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof DocumentNotFoundException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof CasMismatchException || ex instanceof ConcurrentModificationException) {
            return new OptimisticLockingFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ReplicaNotConfiguredException || ex instanceof DurabilityLevelNotAvailableException || ex instanceof DurabilityImpossibleException || ex instanceof DurabilityAmbiguousException) {
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof RequestCanceledException) {
            return new OperationCancellationException(ex.getMessage(), ex);
        }
        if (ex instanceof DesignDocumentNotFoundException || ex instanceof ValueTooLargeException) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TemporaryFailureException || ex instanceof DocumentLockedException) {
            return new TransientDataAccessResourceException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof RuntimeException && ex.getCause() instanceof TimeoutException) {
            return new QueryTimeoutException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof EncodingFailureException || ex instanceof DecodingFailureException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        throw ex;
    }
}

