/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.QueryCriteria;
import org.springframework.data.couchbase.core.query.StringQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class StringN1qlQueryCreator
extends AbstractQueryCreator<Query, QueryCriteria> {
    private final ParameterAccessor accessor;
    private final MappingContext<?, CouchbasePersistentProperty> context;
    private final SpelExpressionParser parser;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final StringBasedN1qlQueryParser queryParser;
    private final QueryMethod queryMethod;
    private final CouchbaseConverter couchbaseConverter;
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();

    public StringN1qlQueryCreator(ParameterAccessor accessor, CouchbaseQueryMethod queryMethod, CouchbaseConverter couchbaseConverter, String bucketName, QueryMethodEvaluationContextProvider evaluationContextProvider, NamedQueries namedQueries) {
        super(new PartTree("dummy", new Object(){
            String dummy;
        }.getClass()), accessor);
        String queryString;
        this.accessor = accessor;
        this.context = couchbaseConverter.getMappingContext();
        this.queryMethod = queryMethod;
        this.couchbaseConverter = couchbaseConverter;
        this.evaluationContextProvider = evaluationContextProvider;
        String namedQueryName = queryMethod.getNamedQueryName();
        if (queryMethod.hasInlineN1qlQuery()) {
            queryString = queryMethod.getInlineN1qlQuery();
        } else if (namedQueries.hasQuery(namedQueryName)) {
            queryString = namedQueries.getQuery(namedQueryName);
        } else {
            throw new IllegalArgumentException("query has no inline Query or named Query not found");
        }
        this.queryParser = new StringBasedN1qlQueryParser(queryString, queryMethod, bucketName, couchbaseConverter, this.getTypeField(), this.getTypeValue());
        this.parser = SPEL_PARSER;
    }

    protected QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected String getTypeField() {
        return this.couchbaseConverter.getTypeKey();
    }

    protected String getTypeValue() {
        return this.getQueryMethod().getEntityInformation().getJavaType().getName();
    }

    protected QueryCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, QueryCriteria.where(path.toDotPath()), iterator);
    }

    protected QueryCriteria and(Part part, QueryCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(path.toDotPath()), iterator);
    }

    protected QueryCriteria or(QueryCriteria base, QueryCriteria criteria) {
        return base.or(criteria);
    }

    protected Query complete(QueryCriteria criteria, Sort sort) {
        N1QLExpression parsedExpression = this.getExpression(this.accessor, StringN1qlQueryCreator.getParameters(this.accessor), null);
        Query q = new StringQuery(parsedExpression.toString()).with(sort);
        JsonValue params = this.queryParser.getPlaceholderValues(this.accessor);
        if (params instanceof JsonArray) {
            q.setPositionalParameters((JsonArray)params);
        } else {
            q.setNamedParameters((JsonObject)params);
        }
        return q;
    }

    private QueryCriteria from(Part part, CouchbasePersistentProperty property, QueryCriteria criteria, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case SIMPLE_PROPERTY: {
                return criteria;
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }

    private N1QLExpression getExpression(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        Pageable pageable;
        EvaluationContext evaluationContext = this.evaluationContextProvider.getEvaluationContext(this.getQueryMethod().getParameters(), runtimeParameters);
        N1QLExpression parsedStatement = N1QLExpression.x(this.queryParser.doParse(this.parser, evaluationContext, false));
        Sort sort = accessor.getSort();
        if (sort.isSorted()) {
            N1QLExpression[] cbSorts = N1qlUtils.createSort(sort);
            parsedStatement = parsedStatement.orderBy(cbSorts);
        }
        if (this.queryMethod.isPageQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            parsedStatement = parsedStatement.limit(pageable.getPageSize()).offset(Math.toIntExact(pageable.getOffset()));
        } else if (this.queryMethod.isSliceQuery()) {
            pageable = accessor.getPageable();
            Assert.notNull((Object)pageable, (String)"Pageable must not be null!");
            parsedStatement = parsedStatement.limit(pageable.getPageSize() + 1).offset(Math.toIntExact(pageable.getOffset()));
        }
        return parsedStatement;
    }

    private static Object[] getParameters(ParameterAccessor accessor) {
        ArrayList params = new ArrayList();
        for (Object o : accessor) {
            params.add(o);
        }
        return params.toArray();
    }
}

