/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.ReactiveQueryResult;
import java.util.Optional;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperation;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.query.Query;
import reactor.core.publisher.Flux;

public class ReactiveRemoveByQueryOperationSupport
implements ReactiveRemoveByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveCouchbaseTemplate template;

    public ReactiveRemoveByQueryOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ReactiveRemoveByQuerySupport<T>(this.template, domainType, ALL_QUERY, QueryScanConsistency.NOT_BOUNDED);
    }

    static class ReactiveRemoveByQuerySupport<T>
    implements ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final QueryScanConsistency scanConsistency;

        ReactiveRemoveByQuerySupport(ReactiveCouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.scanConsistency = scanConsistency;
        }

        @Override
        public Flux<RemoveResult> all() {
            return Flux.defer(() -> {
                String bucket = "`" + this.template.getBucketName() + "`";
                String typeKey = this.template.getConverter().getTypeKey();
                String typeValue = this.template.support().getJavaNameForEntity(this.domainType);
                String where = " WHERE `" + typeKey + "` = \"" + typeValue + "\"";
                String returning = " RETURNING meta().*";
                String statement = "DELETE FROM " + bucket + " " + where + returning;
                return this.template.getCouchbaseClientFactory().getCluster().reactive().query(statement, this.buildQueryOptions()).onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveQueryResult::rowsAsObject).map(row -> new RemoveResult(row.getString("id"), row.getLong("cas"), Optional.empty()));
            });
        }

        private QueryOptions buildQueryOptions() {
            QueryOptions options = QueryOptions.queryOptions();
            if (this.scanConsistency != null) {
                options.scanConsistency(this.scanConsistency);
            }
            return options;
        }

        @Override
        public ReactiveRemoveByQueryOperation.TerminatingRemoveByQuery<T> matching(Query query) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryWithQuery<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency);
        }
    }
}

