/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.view.ViewQuery;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.query.View;
import org.springframework.data.couchbase.repository.CouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.ViewMetadataProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SimpleCouchbaseRepository<T, ID extends Serializable>
implements CouchbaseRepository<T, ID> {
    private final CouchbaseOperations couchbaseOperations;
    private final CouchbaseEntityInformation<T, String> entityInformation;
    private ViewMetadataProvider viewMetadataProvider;

    public SimpleCouchbaseRepository(CouchbaseEntityInformation<T, String> metadata, CouchbaseOperations couchbaseOperations) {
        Assert.notNull(metadata, (String)"CouchbaseEntityInformation must not be null!");
        Assert.notNull((Object)couchbaseOperations, (String)"CouchbaseOperations must not be null!");
        this.entityInformation = metadata;
        this.couchbaseOperations = couchbaseOperations;
    }

    public void setViewMetadataProvider(ViewMetadataProvider viewMetadataProvider) {
        this.viewMetadataProvider = viewMetadataProvider;
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        this.couchbaseOperations.save(entity);
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            this.save(entity);
            result.add(entity);
        }
        return result;
    }

    public Optional<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return Optional.ofNullable(this.couchbaseOperations.findById(this.couchbaseOperations.getConverter().convertForWriteIfNeeded(id).toString(), this.entityInformation.getJavaType()));
    }

    public boolean existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.couchbaseOperations.exists(this.couchbaseOperations.getConverter().convertForWriteIfNeeded(id).toString());
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        this.couchbaseOperations.remove(this.couchbaseOperations.getConverter().convertForWriteIfNeeded(id).toString());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given id must not be null!");
        this.couchbaseOperations.remove(entity);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        for (T entity : entities) {
            this.couchbaseOperations.remove(entity);
        }
    }

    public Iterable<T> findAll() {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(false);
        query.stale(this.getCouchbaseOperations().getDefaultConsistency().viewConsistency());
        return this.couchbaseOperations.findByView(query, this.entityInformation.getJavaType());
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(false);
        query.stale(this.getCouchbaseOperations().getDefaultConsistency().viewConsistency());
        JsonArray keys = JsonArray.create();
        for (Serializable id : ids) {
            keys.add(this.couchbaseOperations.getConverter().convertForWriteIfNeeded(id));
        }
        query.keys(keys);
        return this.couchbaseOperations.findByView(query, this.entityInformation.getJavaType());
    }

    public long count() {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(true);
        query.stale(this.getCouchbaseOperations().getDefaultConsistency().viewConsistency());
        ViewResult response = this.couchbaseOperations.queryView(query);
        long count = 0L;
        for (ViewRow row : response) {
            count += Long.parseLong(String.valueOf(row.value()));
        }
        return count;
    }

    public void deleteAll() {
        ResolvedView resolvedView = this.determineView();
        ViewQuery query = ViewQuery.from((String)resolvedView.getDesignDocument(), (String)resolvedView.getViewName());
        query.reduce(false);
        query.stale(this.getCouchbaseOperations().getDefaultConsistency().viewConsistency());
        ViewResult response = this.couchbaseOperations.queryView(query);
        for (ViewRow row : response) {
            try {
                this.couchbaseOperations.remove(row.id());
            }
            catch (DataRetrievalFailureException e) {
                if (e.getCause() instanceof DocumentDoesNotExistException) continue;
                throw e;
            }
        }
    }

    @Override
    public CouchbaseOperations getCouchbaseOperations() {
        return this.couchbaseOperations;
    }

    protected CouchbaseEntityInformation<T, String> getEntityInformation() {
        return this.entityInformation;
    }

    private ResolvedView determineView() {
        String designDocument = StringUtils.uncapitalize((String)this.entityInformation.getJavaType().getSimpleName());
        String viewName = "all";
        View view = this.viewMetadataProvider.getView();
        if (view != null) {
            designDocument = view.designDocument();
            viewName = view.viewName();
        }
        return new ResolvedView(designDocument, viewName);
    }

    private final class ResolvedView {
        private final String designDocument;
        private final String viewName;

        public ResolvedView(String designDocument, String viewName) {
            this.designDocument = designDocument;
            this.viewName = viewName;
        }

        private String getDesignDocument() {
            return this.designDocument;
        }

        private String getViewName() {
            return this.viewName;
        }
    }
}

