/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query.support;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.StringFunctions;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.query.ConvertingIterator;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.repository.query.parser.Part;

public class N1qlQueryCreatorUtils {
    public static Expression prepareExpression(CouchbaseConverter converter, Part part, Iterator<Object> iterator, AtomicInteger position, JsonArray placeHolderValues) {
        boolean isString;
        PersistentPropertyPath<CouchbasePersistentProperty> path = N1qlUtils.getPathWithAlternativeFieldNames(converter, part.getProperty());
        ConvertingIterator parameterValues = new ConvertingIterator(iterator, converter);
        String fieldNamePath = N1qlUtils.getDottedPathWithAlternativeFieldNames(path);
        boolean ignoreCase = false;
        Class<?> leafType = converter.getWriteClassFor(((CouchbasePersistentProperty)path.getLeafProperty()).getType());
        boolean bl = isString = leafType == String.class;
        if (part.shouldIgnoreCase() == Part.IgnoreCaseType.WHEN_POSSIBLE) {
            ignoreCase = isString;
        } else if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) {
            if (!isString) {
                throw new IllegalArgumentException(String.format("Part %s must be of type String but was %s", fieldNamePath, leafType));
            }
            ignoreCase = true;
        }
        return N1qlQueryCreatorUtils.createExpression(part.getType(), fieldNamePath, ignoreCase, parameterValues, position, placeHolderValues);
    }

    public static Expression createExpression(Part.Type partType, String fieldNamePath, boolean ignoreCase, Iterator<Object> parameterValues, AtomicInteger position, JsonArray placeHolderValues) {
        Expression exp;
        Expression left = ignoreCase ? StringFunctions.lower((Expression)Expression.x((String)fieldNamePath)) : Expression.x((String)fieldNamePath);
        switch (partType) {
            case BETWEEN: {
                exp = left.between(Expression.x((String)N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase)).and(Expression.x((String)N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase))));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case IS_NOT_NULL: {
                exp = left.isNotNull();
                break;
            }
            case IS_NULL: {
                exp = left.isNull();
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                exp = left.ne(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case SIMPLE_PROPERTY: {
                exp = left.eq(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                exp = left.lt(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case LESS_THAN_EQUAL: {
                exp = left.lte(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case GREATER_THAN_EQUAL: {
                exp = left.gte(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case AFTER: 
            case GREATER_THAN: {
                exp = left.gt(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case NOT_LIKE: {
                exp = left.notLike(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case LIKE: {
                exp = left.like(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case STARTING_WITH: {
                exp = left.like(N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase) + " || '%'");
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case ENDING_WITH: {
                exp = left.like("'%' || " + N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case NOT_CONTAINING: {
                exp = left.notLike("'%' || " + N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase) + " || '%'");
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case CONTAINING: {
                exp = left.like("'%' || " + N1qlQueryCreatorUtils.getPlaceHolder(position, ignoreCase) + " || '%'");
                placeHolderValues.add(N1qlQueryCreatorUtils.getValue(parameterValues));
                break;
            }
            case NOT_IN: {
                exp = left.notIn(N1qlQueryCreatorUtils.getPlaceHolder(position, false));
                placeHolderValues.add(N1qlQueryCreatorUtils.getArray(parameterValues));
                break;
            }
            case IN: {
                exp = left.in(N1qlQueryCreatorUtils.getPlaceHolder(position, false));
                placeHolderValues.add(N1qlQueryCreatorUtils.getArray(parameterValues));
                break;
            }
            case TRUE: {
                exp = left.eq(true);
                break;
            }
            case FALSE: {
                exp = left.eq(false);
                break;
            }
            case REGEX: {
                exp = Expression.x((String)("REGEXP_LIKE(" + left.toString() + ", " + N1qlQueryCreatorUtils.getPlaceHolder(position, false) + ")"));
                placeHolderValues.add(N1qlQueryCreatorUtils.getValueAsString(parameterValues));
                break;
            }
            case EXISTS: {
                exp = left.isNotMissing();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword in N1QL query derivation");
            }
        }
        return exp;
    }

    protected static String getPlaceHolder(AtomicInteger position, boolean ignoreCase) {
        String placeHolder = "$" + position.getAndIncrement();
        if (ignoreCase) {
            placeHolder = StringFunctions.lower((Expression)Expression.x((String)placeHolder)).toString();
        }
        return placeHolder;
    }

    protected static String getValueAsString(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        String pattern = next == null ? "" : String.valueOf(next);
        return pattern;
    }

    protected static Expression like(Iterator<Object> parameterValues, boolean ignoreCase, boolean anyPrefix, boolean anySuffix) {
        Expression converted;
        Object next = parameterValues.next();
        if (next == null) {
            return Expression.NULL();
        }
        if (next instanceof String) {
            String pattern = (String)next;
            if (anyPrefix) {
                pattern = "%" + pattern;
            }
            if (anySuffix) {
                pattern = pattern + "%";
            }
            converted = Expression.s((String[])new String[]{pattern});
        } else {
            converted = Expression.x((String)String.valueOf(next));
        }
        if (ignoreCase) {
            return StringFunctions.lower((Expression)converted);
        }
        return converted;
    }

    protected static Object getValue(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        if (next instanceof Enum) {
            next = String.valueOf(next);
        }
        return next;
    }

    protected static JsonArray getArray(Iterator<Object> parameterValues) {
        Object next = parameterValues.next();
        Object[] values = next instanceof Collection ? ((Collection)next).toArray() : (next.getClass().isArray() ? (Object[])next : new Object[]{next});
        return JsonArray.from((Object[])values);
    }
}

