/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.AggregateFunctions;
import com.couchbase.client.java.query.dsl.path.AsPath;
import com.couchbase.client.java.query.dsl.path.FromPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.WherePath;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.N1qlQueryCreator;
import org.springframework.data.couchbase.repository.query.ReactiveAbstractN1qlBasedQuery;
import org.springframework.data.couchbase.repository.query.support.N1qlUtils;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;

public class ReactivePartTreeN1qlBasedQuery
extends ReactiveAbstractN1qlBasedQuery {
    private final PartTree partTree;
    private JsonValue placeHolderValues;

    public ReactivePartTreeN1qlBasedQuery(CouchbaseQueryMethod queryMethod, RxJavaCouchbaseOperations operations) {
        super(queryMethod, operations);
        this.partTree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
    }

    @Override
    protected JsonValue getPlaceholderValues(ParameterAccessor accessor) {
        return this.placeHolderValues;
    }

    @Override
    protected Statement getStatement(ParameterAccessor accessor, Object[] runtimeParameters, ReturnedType returnedType) {
        String bucketName = this.getCouchbaseOperations().getCouchbaseBucket().name();
        Expression bucket = N1qlUtils.escapedBucket(bucketName);
        FromPath select = this.partTree.isCountProjection() ? Select.select((Expression[])new Expression[]{AggregateFunctions.count((String)"*")}) : N1qlUtils.createSelectClauseForEntity(bucketName, returnedType, this.getCouchbaseOperations().getConverter());
        AsPath selectFrom = select.from(bucket);
        N1qlQueryCreator queryCreator = new N1qlQueryCreator(this.partTree, accessor, (WherePath)selectFrom, this.getCouchbaseOperations().getConverter(), this.getQueryMethod());
        LimitPath selectFromWhereOrderBy = (LimitPath)queryCreator.createQuery();
        this.placeHolderValues = queryCreator.getPlaceHolderValues();
        if (this.partTree.isLimiting()) {
            return selectFromWhereOrderBy.limit(this.partTree.getMaxResults().intValue());
        }
        return selectFromWhereOrderBy;
    }
}

