/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.couchbase.core.RxJavaCouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.util.Assert;

public class ReactiveRepositoryOperationsMapping {
    private RxJavaCouchbaseOperations defaultOperations;
    private Map<String, RxJavaCouchbaseOperations> byRepository = new HashMap<String, RxJavaCouchbaseOperations>();
    private Map<String, RxJavaCouchbaseOperations> byEntity = new HashMap<String, RxJavaCouchbaseOperations>();

    public ReactiveRepositoryOperationsMapping(RxJavaCouchbaseOperations defaultOperations) {
        Assert.notNull((Object)defaultOperations);
        this.defaultOperations = defaultOperations;
    }

    public ReactiveRepositoryOperationsMapping setDefault(RxJavaCouchbaseOperations aDefault) {
        Assert.notNull((Object)aDefault);
        this.defaultOperations = aDefault;
        return this;
    }

    public ReactiveRepositoryOperationsMapping map(Class<?> repositoryInterface, RxJavaCouchbaseOperations operations) {
        this.byRepository.put(repositoryInterface.getName(), operations);
        return this;
    }

    public ReactiveRepositoryOperationsMapping mapEntity(Class<?> entityClass, RxJavaCouchbaseOperations operations) {
        this.byEntity.put(entityClass.getName(), operations);
        return this;
    }

    public RxJavaCouchbaseOperations getDefault() {
        return this.defaultOperations;
    }

    public MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> getMappingContext() {
        return this.defaultOperations.getConverter().getMappingContext();
    }

    public RxJavaCouchbaseOperations resolve(Class<?> repositoryInterface, Class<?> domainType) {
        RxJavaCouchbaseOperations result = this.byRepository.get(repositoryInterface.getName());
        if (result != null) {
            return result;
        }
        result = this.byEntity.get(domainType.getName());
        if (result != null) {
            return result;
        }
        return this.defaultOperations;
    }
}

