/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.couchbase.config.CouchbaseBucketFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class CouchbaseBucketParser
extends AbstractSingleBeanDefinitionParser {
    public static final String CLUSTER_REF_ATTR = "cluster-ref";
    public static final String BUCKETNAME_ATTR = "bucketName";
    public static final String USERNAME_ATTR = "username";
    public static final String BUCKETPASSWORD_ATTR = "bucketPassword";

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "couchbaseBucket";
    }

    protected Class getBeanClass(Element element) {
        return CouchbaseBucketFactoryBean.class;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String password;
        String username;
        String clusterRef = element.getAttribute(CLUSTER_REF_ATTR);
        if (!StringUtils.hasText((String)clusterRef)) {
            clusterRef = "couchbaseCluster";
        }
        builder.addConstructorArgReference(clusterRef);
        String bucketName = element.getAttribute(BUCKETNAME_ATTR);
        if (StringUtils.hasText((String)bucketName)) {
            builder.addConstructorArgValue((Object)bucketName);
        }
        if (StringUtils.hasText((String)(username = element.getAttribute(USERNAME_ATTR)))) {
            builder.addConstructorArgValue((Object)username);
        }
        if (StringUtils.hasText((String)(password = element.getAttribute(BUCKETPASSWORD_ATTR)))) {
            builder.addConstructorArgValue((Object)password);
        }
    }
}

