/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.couchbase.config.CouchbaseConfigurationSupport;
import org.springframework.data.couchbase.config.CouchbaseConfigurer;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;

@Configuration
public abstract class AbstractCouchbaseDataConfiguration
extends CouchbaseConfigurationSupport {
    protected abstract CouchbaseConfigurer couchbaseConfigurer();

    @Bean(name={"couchbaseTemplate"})
    public CouchbaseTemplate couchbaseTemplate() throws Exception {
        CouchbaseTemplate template = new CouchbaseTemplate(this.couchbaseConfigurer().couchbaseClusterInfo(), this.couchbaseConfigurer().couchbaseClient(), this.mappingCouchbaseConverter(), this.translationService());
        template.setDefaultConsistency(this.getDefaultConsistency());
        return template;
    }

    @Bean(name={"couchbaseRepositoryOperationsMapping"})
    public RepositoryOperationsMapping repositoryOperationsMapping(CouchbaseTemplate couchbaseTemplate) throws Exception {
        RepositoryOperationsMapping baseMapping = new RepositoryOperationsMapping(couchbaseTemplate);
        this.configureRepositoryOperationsMapping(baseMapping);
        return baseMapping;
    }

    protected void configureRepositoryOperationsMapping(RepositoryOperationsMapping mapping) {
    }
}

