/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.monitor;

import com.couchbase.client.CouchbaseClient;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractMonitor {
    private CouchbaseClient client;
    private RestTemplate template = new RestTemplate();

    protected AbstractMonitor(CouchbaseClient client) {
        this.client = client;
    }

    public CouchbaseClient getClient() {
        return this.client;
    }

    protected RestTemplate getTemplate() {
        return this.template;
    }

    protected String randomAvailableHostname() {
        ArrayList available = (ArrayList)this.client.getAvailableServers();
        Collections.shuffle(available);
        return ((InetSocketAddress)available.get(0)).getHostName();
    }

    protected Map<SocketAddress, Map<String, String>> getStats() {
        return this.client.getStats();
    }

    protected Map<String, String> getStats(SocketAddress node) {
        return this.getStats().get(node);
    }
}

