/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.aot.hint.annotation.ReflectiveRuntimeHintsRegistrar;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.aot.AotProcessingException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.env.Environment;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.AotMappingContext;
import org.springframework.data.aot.AotTypeConfiguration;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.QTypeContributor;
import org.springframework.data.util.TypeContributor;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class DefaultAotContext
implements AotContext {
    private final AotMappingContext mappingContext;
    private final ConfigurableListableBeanFactory factory;
    private final Map<Class<?>, ContextualTypeConfiguration> typeConfigurations = new HashMap();
    private final Environment environment;
    private final ReflectiveRuntimeHintsRegistrar runtimeHintsRegistrar = new ReflectiveRuntimeHintsRegistrar();

    public DefaultAotContext(BeanFactory beanFactory, Environment environment) {
        this(beanFactory, environment, new AotMappingContext());
    }

    DefaultAotContext(BeanFactory beanFactory, Environment environment, AotMappingContext mappingContext) {
        DefaultListableBeanFactory defaultListableBeanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory cbf = (ConfigurableListableBeanFactory)beanFactory;
            defaultListableBeanFactory = cbf;
        } else {
            defaultListableBeanFactory = new DefaultListableBeanFactory(beanFactory);
        }
        this.factory = defaultListableBeanFactory;
        this.environment = environment;
        this.mappingContext = mappingContext;
    }

    @Override
    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.factory;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public AotContext.TypeIntrospector introspectType(String typeName) {
        return new DefaultTypeIntrospector(typeName);
    }

    @Override
    public AotContext.IntrospectedBeanDefinition introspectBeanDefinition(String beanName) {
        return new DefaultIntrospectedBeanDefinition(beanName);
    }

    @Override
    public void typeConfiguration(Class<?> type, Consumer<AotTypeConfiguration> configurationConsumer) {
        configurationConsumer.accept(this.typeConfigurations.computeIfAbsent(type, it -> new ContextualTypeConfiguration(type)));
    }

    @Override
    public void contributeTypeConfigurations(GenerationContext generationContext) {
        this.typeConfigurations.forEach((type, configuration) -> configuration.contribute(this.environment, generationContext));
    }

    class DefaultTypeIntrospector
    implements AotContext.TypeIntrospector {
        private final String typeName;

        DefaultTypeIntrospector(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public boolean isTypePresent() {
            return ClassUtils.isPresent((String)this.typeName, (ClassLoader)DefaultAotContext.this.getClassLoader());
        }

        @Override
        public Class<?> resolveRequiredType() throws TypeNotPresentException {
            try {
                return ClassUtils.forName((String)this.typeName, (ClassLoader)DefaultAotContext.this.getClassLoader());
            }
            catch (ClassNotFoundException cause) {
                throw new TypeNotPresentException(this.typeName, cause);
            }
        }

        @Override
        public Optional<Class<?>> resolveType() {
            return this.isTypePresent() ? Optional.of(this.resolveRequiredType()) : Optional.empty();
        }

        @Override
        public boolean hasBean() {
            return !this.getBeanNames().isEmpty();
        }

        @Override
        public List<String> getBeanNames() {
            return this.isTypePresent() ? Arrays.asList(DefaultAotContext.this.factory.getBeanNamesForType(this.resolveRequiredType())) : Collections.emptyList();
        }
    }

    class DefaultIntrospectedBeanDefinition
    implements AotContext.IntrospectedBeanDefinition {
        private final String beanName;

        DefaultIntrospectedBeanDefinition(String beanName) {
            this.beanName = beanName;
        }

        @Override
        public boolean isPresent() {
            return DefaultAotContext.this.factory.containsBeanDefinition(this.beanName);
        }

        @Override
        public boolean isFactoryBean() {
            return DefaultAotContext.this.factory.isFactoryBean(this.beanName);
        }

        @Override
        public BeanDefinition getBeanDefinition() throws NoSuchBeanDefinitionException {
            return DefaultAotContext.this.factory.getBeanDefinition(this.beanName);
        }

        @Override
        public RootBeanDefinition getRootBeanDefinition() throws NoSuchBeanDefinitionException {
            BeanDefinition beanDefinition = this.getBeanDefinition();
            if (beanDefinition instanceof RootBeanDefinition) {
                RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
                return rootBeanDefinition;
            }
            throw new IllegalStateException(String.format("%s is not a root bean", this.beanName));
        }

        @Override
        public @Nullable Class<?> resolveType() {
            return DefaultAotContext.this.factory.getType(this.beanName, false);
        }
    }

    class ContextualTypeConfiguration
    implements AotTypeConfiguration {
        private final Class<?> type;
        private boolean forDataBinding = false;
        private final Set<MemberCategory> categories = new HashSet<MemberCategory>(5);
        private boolean contributeAccessors = false;
        private boolean forQuerydsl = false;
        private final List<List<TypeReference>> proxies = new ArrayList<List<TypeReference>>();

        ContextualTypeConfiguration(Class<?> type) {
            this.type = type;
        }

        @Override
        public AotTypeConfiguration forDataBinding() {
            this.forDataBinding = true;
            return this;
        }

        @Override
        public AotTypeConfiguration forReflectiveAccess(MemberCategory ... categories) {
            this.categories.addAll(Arrays.asList(categories));
            return this;
        }

        @Override
        public AotTypeConfiguration contributeAccessors() {
            this.contributeAccessors = true;
            return this;
        }

        @Override
        public AotTypeConfiguration proxyInterface(List<TypeReference> interfaces) {
            this.proxies.add(interfaces);
            return this;
        }

        @Override
        public AotTypeConfiguration forQuerydsl() {
            this.forQuerydsl = true;
            return this;
        }

        public void contribute(Environment environment, GenerationContext generationContext) {
            try {
                this.doContribute(environment, generationContext);
            }
            catch (RuntimeException e) {
                throw new AotProcessingException("Cannot contribute Ahead-of-Time optimizations for '" + this.type.getName() + "'", (Throwable)e);
            }
        }

        private void doContribute(Environment environment, GenerationContext generationContext) {
            AccessorContributionConfiguration configuration;
            if (!this.categories.isEmpty()) {
                generationContext.getRuntimeHints().reflection().registerType(this.type, (MemberCategory[])this.categories.toArray(MemberCategory[]::new));
            }
            if (this.contributeAccessors && (configuration = AccessorContributionConfiguration.of(environment)).shouldContributeAccessors(this.type)) {
                DefaultAotContext.this.mappingContext.contribute(this.type);
            }
            if (this.forDataBinding) {
                DefaultAotContext.this.runtimeHintsRegistrar.registerRuntimeHints(generationContext.getRuntimeHints(), new Class[]{this.type});
                TypeContributor.contribute(this.type, Set.of("org.springframework.data"), generationContext);
            }
            if (this.forQuerydsl) {
                QTypeContributor.contributeEntityPath(this.type, generationContext, DefaultAotContext.this.factory.getBeanClassLoader());
            }
            if (!this.proxies.isEmpty()) {
                for (List<TypeReference> proxyInterfaces : this.proxies) {
                    generationContext.getRuntimeHints().proxies().registerJdkProxy((TypeReference[])Stream.concat(Stream.of(TypeReference.of(this.type)), proxyInterfaces.stream()).toArray(TypeReference[]::new));
                }
            }
        }
    }

    private record AccessorContributionConfiguration(boolean enabled, Lazy<String> include, Lazy<String> exclude) {
        public static final String ACCESSORS_ENABLED = "spring.aot.data.accessors.enabled";
        public static final String INCLUDE_PATTERNS = "spring.aot.data.accessors.include";
        public static final String EXCLUDE_PATTERNS = "spring.aot.data.accessors.exclude";
        private static final AntPathMatcher antPathMatcher = new AntPathMatcher(".");

        private AccessorContributionConfiguration(boolean enabled, Supplier<String> include, Supplier<String> exclude) {
            this(enabled, Lazy.of(include), Lazy.of(exclude));
        }

        public static AccessorContributionConfiguration of(Environment environment) {
            return new AccessorContributionConfiguration((boolean)((Boolean)environment.getProperty(ACCESSORS_ENABLED, Boolean.class, (Object)true)), () -> (String)environment.getProperty(INCLUDE_PATTERNS, String.class, (Object)""), () -> (String)environment.getProperty(EXCLUDE_PATTERNS, String.class, (Object)""));
        }

        boolean shouldContributeAccessors(Class<?> type) {
            if (!this.enabled) {
                return false;
            }
            if (StringUtils.hasText((String)this.include.get())) {
                String[] includes;
                for (String includePattern : includes = this.include.get().split(",")) {
                    if (!antPathMatcher.match(includePattern.trim(), type.getName())) continue;
                    return true;
                }
            }
            if (StringUtils.hasText((String)this.exclude.get())) {
                String[] excludes;
                for (String excludePattern : excludes = this.exclude.get().split(",")) {
                    if (!antPathMatcher.match(excludePattern.trim(), type.getName())) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

