/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.aot.generate.AotRepositoryConstructorBuilder;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.TypeSpec;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class AotRepositoryBeanDefinitionPropertiesDecorator {
    static final Map<ResolvableType, String> RESERVED_TYPES = new LinkedHashMap<ResolvableType, String>(3);
    private final Supplier<CodeBlock> inheritedProperties;
    private final RepositoryContributor repositoryContributor;

    public AotRepositoryBeanDefinitionPropertiesDecorator(Supplier<CodeBlock> inheritedProperties, RepositoryContributor repositoryContributor) {
        Assert.notNull((Object)repositoryContributor.getContributedTypeName(), (String)"Contributed type name must not be null");
        this.inheritedProperties = inheritedProperties;
        this.repositoryContributor = repositoryContributor;
    }

    public CodeBlock decorate() {
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.add(this.inheritedProperties.get());
        MethodSpec.Builder callbackMethod = MethodSpec.methodBuilder((String)"getRepositoryFragments").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(RepositoryComposition.RepositoryFragments.class);
        ReflectionUtils.doWithMethods(RepositoryFactoryBeanSupport.RepositoryFragmentsFunction.class, it -> {
            for (int i = 0; i < it.getParameterCount(); ++i) {
                MethodParameter parameter = new MethodParameter(it, i);
                parameter.initParameterNameDiscovery((ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
                callbackMethod.addParameter((Type)parameter.getParameterType(), parameter.getParameterName(), new Modifier[0]);
            }
        }, method -> method.getName().equals("getRepositoryFragments"));
        callbackMethod.addCode(this.buildCallbackBody());
        TypeSpec repositoryFragmentsFunction = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).superclass(RepositoryFactoryBeanSupport.RepositoryFragmentsFunction.class).addMethod(callbackMethod.build()).build();
        builder.addStatement("beanDefinition.getPropertyValues().addPropertyValue($S, $L)", new Object[]{"repositoryFragmentsFunction", repositoryFragmentsFunction});
        return builder.build();
    }

    private CodeBlock buildCallbackBody() {
        Assert.state((this.repositoryContributor.getContributedTypeName() != null ? 1 : 0) != 0, (String)"ContributedTypeName must not be null");
        CodeBlock.Builder callback = CodeBlock.builder();
        ArrayList<String> arguments = new ArrayList<String>();
        for (Map.Entry<String, AotRepositoryFragmentMetadata.ConstructorArgument> entry : this.repositoryContributor.getConstructorArguments().entrySet()) {
            AotRepositoryFragmentMetadata.ConstructorArgument argument = entry.getValue();
            AotRepositoryConstructorBuilder.ParameterOrigin parameterOrigin = argument.parameterOrigin();
            String ref = parameterOrigin.getReference();
            CodeBlock codeBlock = parameterOrigin.getCodeBlock();
            if (StringUtils.hasText((String)ref)) {
                arguments.add(ref);
                if (codeBlock.isEmpty()) continue;
                callback.add(codeBlock);
                continue;
            }
            arguments.add((String)codeBlock);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(RepositoryComposition.RepositoryFragments.class);
        args.add(this.repositoryContributor.getContributedTypeName().getName());
        args.addAll(arguments);
        callback.addStatement("return $T.just(new $L(%s%s))".formatted("$L".repeat(arguments.isEmpty() ? 0 : 1), ", $L".repeat(Math.max(0, arguments.size() - 1))), args.toArray());
        return callback.build();
    }

    static {
        RESERVED_TYPES.put(ResolvableType.forClass(BeanDefinition.class), "beanDefinition");
        RESERVED_TYPES.put(ResolvableType.forClass(BeanFactory.class), "beanFactory");
        RESERVED_TYPES.put(ResolvableType.forClass(RepositoryFactoryBeanSupport.FragmentCreationContext.class), "context");
    }
}

