/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.Alias;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class ConfigurableTypeInformationMapper
implements TypeInformationMapper {
    private final Map<TypeInformation<?>, Alias> typeToAlias;
    private final Map<Alias, TypeInformation<?>> aliasToType;

    public ConfigurableTypeInformationMapper(Map<? extends Class<?>, String> sourceTypeMap) {
        Assert.notNull(sourceTypeMap, (String)"SourceTypeMap must not be null");
        this.typeToAlias = new HashMap(sourceTypeMap.size());
        this.aliasToType = new HashMap(sourceTypeMap.size());
        for (Map.Entry<Class<?>, String> entry : sourceTypeMap.entrySet()) {
            TypeInformation<?> type = TypeInformation.of(entry.getKey());
            Alias alias = Alias.of(entry.getValue());
            if (this.typeToAlias.containsValue(alias)) {
                throw new IllegalArgumentException(String.format("Detected mapping ambiguity; String %s cannot be mapped to more than one type", alias));
            }
            this.typeToAlias.put(type, alias);
            this.aliasToType.put(alias, type);
        }
    }

    @Override
    public Alias createAliasFor(TypeInformation<?> type) {
        return this.typeToAlias.getOrDefault(type, Alias.NONE);
    }

    @Override
    public @Nullable TypeInformation<?> resolveTypeFrom(Alias alias) {
        return this.aliasToType.get(alias);
    }
}

