/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.ResolvableType;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.javapoet.ParameterSpec;
import org.springframework.javapoet.TypeName;

class MethodMetadata {
    private final Map<String, ParameterSpec> methodArguments = new LinkedHashMap<String, ParameterSpec>();
    private final Map<String, String> localVariables = new LinkedHashMap<String, String>();
    private final ResolvableType actualReturnType;
    private final ResolvableType returnType;

    MethodMetadata(RepositoryInformation repositoryInformation, Method method) {
        this.returnType = repositoryInformation.getReturnType(method).toResolvableType();
        this.actualReturnType = repositoryInformation.getReturnedDomainTypeInformation(method).toResolvableType();
        this.initParameters(repositoryInformation, method, (ParameterNameDiscoverer)new DefaultParameterNameDiscoverer());
    }

    private void initParameters(RepositoryInformation repositoryInformation, Method method, ParameterNameDiscoverer nameDiscoverer) {
        ResolvableType repositoryInterface = ResolvableType.forClass(repositoryInformation.getRepositoryInterface());
        for (Parameter parameter : method.getParameters()) {
            MethodParameter methodParameter = MethodParameter.forParameter((Parameter)parameter);
            methodParameter.initParameterNameDiscovery(nameDiscoverer);
            ResolvableType resolvableParameterType = ResolvableType.forMethodParameter((MethodParameter)methodParameter, (ResolvableType)repositoryInterface);
            TypeName parameterType = TypeName.get((Type)resolvableParameterType.getType());
            this.addParameter(ParameterSpec.builder((TypeName)parameterType, (String)methodParameter.getParameterName(), (Modifier[])new Modifier[0]).build());
        }
    }

    ResolvableType getReturnType() {
        return this.returnType;
    }

    ResolvableType getActualReturnType() {
        return this.actualReturnType;
    }

    void addParameter(ParameterSpec parameterSpec) {
        this.methodArguments.put(parameterSpec.name, parameterSpec);
    }

    Map<String, ParameterSpec> getMethodArguments() {
        return this.methodArguments;
    }

    @Nullable String getParameterName(int position) {
        if (0 > position) {
            return null;
        }
        ArrayList<Map.Entry<String, ParameterSpec>> entries = new ArrayList<Map.Entry<String, ParameterSpec>>(this.methodArguments.entrySet());
        if (position < entries.size()) {
            return (String)((Map.Entry)entries.get(position)).getKey();
        }
        return null;
    }

    Map<String, String> getLocalVariables() {
        return this.localVariables;
    }
}

