/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.aot.generate;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.repository.aot.generate.AotRepositoryFragmentMetadata;
import org.springframework.data.repository.aot.generate.CodeBlocks;
import org.springframework.data.repository.aot.generate.MethodMetadata;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.javapoet.FieldSpec;
import org.springframework.javapoet.ParameterSpec;
import org.springframework.javapoet.TypeName;
import org.springframework.util.ObjectUtils;

public class AotQueryMethodGenerationContext {
    private final Method method;
    private final MergedAnnotations annotations;
    private final QueryMethod queryMethod;
    private final RepositoryInformation repositoryInformation;
    private final AotRepositoryFragmentMetadata targetTypeMetadata;
    private final MethodMetadata targetMethodMetadata;
    private final CodeBlocks codeBlocks;

    AotQueryMethodGenerationContext(RepositoryInformation repositoryInformation, Method method, QueryMethod queryMethod, AotRepositoryFragmentMetadata targetTypeMetadata) {
        this.method = method;
        this.annotations = MergedAnnotations.from((AnnotatedElement)method);
        this.queryMethod = queryMethod;
        this.repositoryInformation = repositoryInformation;
        this.targetTypeMetadata = targetTypeMetadata;
        this.targetMethodMetadata = new MethodMetadata(repositoryInformation, method);
        this.codeBlocks = new CodeBlocks(targetTypeMetadata);
    }

    AotRepositoryFragmentMetadata getTargetTypeMetadata() {
        return this.targetTypeMetadata;
    }

    MethodMetadata getTargetMethodMetadata() {
        return this.targetMethodMetadata;
    }

    public RepositoryInformation getRepositoryInformation() {
        return this.repositoryInformation;
    }

    public Method getMethod() {
        return this.method;
    }

    public CodeBlocks codeBlocks() {
        return this.codeBlocks;
    }

    public MergedAnnotations getAnnotations() {
        return this.annotations;
    }

    public <A extends Annotation> MergedAnnotation<A> getAnnotation(Class<A> annotationType) {
        return this.annotations.get(annotationType);
    }

    public ReturnedType getReturnedType() {
        return this.queryMethod.getResultProcessor().getReturnedType();
    }

    public ResolvableType getActualReturnType() {
        return this.targetMethodMetadata.getActualReturnType();
    }

    public ResolvableType getReturnType() {
        return this.targetMethodMetadata.getReturnType();
    }

    public TypeName getReturnTypeName() {
        return TypeName.get((Type)this.getReturnType().getType());
    }

    public String getRequiredBindableParameterName(int parameterIndex) {
        String name = this.getBindableParameterName(parameterIndex);
        if (ObjectUtils.isEmpty((Object)name)) {
            throw new IllegalArgumentException("No bindable parameter with index %d".formatted(parameterIndex));
        }
        return name;
    }

    public @Nullable String getBindableParameterName(int parameterIndex) {
        int bindable = 0;
        int totalIndex = 0;
        for (Parameter parameter : this.queryMethod.getParameters()) {
            if (parameter.isBindable()) {
                if (bindable == parameterIndex) {
                    return this.getParameterName(totalIndex);
                }
                ++bindable;
            }
            ++totalIndex;
        }
        return null;
    }

    public String getRequiredBindableParameterName(String parameterName) {
        String name = this.getBindableParameterName(parameterName);
        if (ObjectUtils.isEmpty((Object)name)) {
            throw new IllegalArgumentException("No bindable parameter with name '%s'".formatted(parameterName));
        }
        return name;
    }

    public @Nullable String getBindableParameterName(String parameterName) {
        int totalIndex = 0;
        for (Parameter parameter : this.queryMethod.getParameters()) {
            ++totalIndex;
            if (!parameter.isBindable() || !parameter.getName().filter(it -> it.equals(parameterName)).isPresent()) continue;
            return this.getParameterName(totalIndex - 1);
        }
        return null;
    }

    public List<String> getBindableParameterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Parameter parameter : this.queryMethod.getParameters().getBindableParameters()) {
            parameter.getName().map(result::add);
        }
        return result;
    }

    public List<String> getAllParameterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Parameter parameter : this.queryMethod.getParameters()) {
            parameter.getName().map(result::add);
        }
        return result;
    }

    public boolean hasField(String fieldName) {
        return this.targetTypeMetadata.hasField(fieldName);
    }

    public void addField(String fieldName, TypeName type, Modifier ... modifiers) {
        this.targetTypeMetadata.addField(fieldName, type, modifiers);
    }

    public void addField(FieldSpec fieldSpec) {
        this.targetTypeMetadata.addField(fieldSpec);
    }

    public @Nullable String fieldNameOf(Class<?> type) {
        return this.targetTypeMetadata.fieldNameOf(type);
    }

    public @Nullable String getParameterNameOf(Class<?> type) {
        return this.targetMethodMetadata.getParameterNameOf(type);
    }

    public @Nullable String getParameterName(int position) {
        if (0 > position) {
            return null;
        }
        ArrayList<Map.Entry<String, ParameterSpec>> entries = new ArrayList<Map.Entry<String, ParameterSpec>>(this.targetMethodMetadata.getMethodArguments().entrySet());
        if (position < entries.size()) {
            return (String)((Map.Entry)entries.get(position)).getKey();
        }
        return null;
    }

    public void addParameter(ParameterSpec parameter) {
        this.targetMethodMetadata.addParameter(parameter);
    }

    public @Nullable String getSortParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getSortIndex());
    }

    public @Nullable String getPageableParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getPageableIndex());
    }

    public @Nullable String getLimitParameterName() {
        return this.getParameterName(this.queryMethod.getParameters().getLimitIndex());
    }
}

