/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractPersistentProperty<P extends PersistentProperty<P>>
implements PersistentProperty<P> {
    private static final Field CAUSE_FIELD = ReflectionUtils.findRequiredField(Throwable.class, "cause");
    private final String name;
    private final TypeInformation<?> information;
    private final Class<?> rawType;
    private final Lazy<Association<P>> association;
    private final PersistentEntity<?, P> owner;
    private final Property property;
    private final Lazy<Integer> hashCode;
    private final Lazy<Boolean> usePropertyAccess;
    private final Lazy<Optional<? extends TypeInformation<?>>> entityTypeInformation;
    private final Method getter;
    private final Method setter;
    private final Field field;

    public AbstractPersistentProperty(Property property, PersistentEntity<?, P> owner, SimpleTypeHolder simpleTypeHolder) {
        Assert.notNull((Object)simpleTypeHolder, (String)"SimpleTypeHolder must not be null!");
        Assert.notNull(owner, (String)"Owner entity must not be null!");
        this.name = property.getName();
        this.information = owner.getTypeInformation().getRequiredProperty(this.getName());
        this.rawType = this.information.getType();
        this.property = property;
        this.association = Lazy.of(() -> this.isAssociation() ? this.createAssociation() : null);
        this.owner = owner;
        this.hashCode = Lazy.of(property::hashCode);
        this.usePropertyAccess = Lazy.of(() -> owner.getType().isInterface() || CAUSE_FIELD.equals(this.getField()));
        this.entityTypeInformation = Lazy.of(() -> Optional.ofNullable(this.information.getActualType()).filter(it -> !simpleTypeHolder.isSimpleType(it.getType())).filter(it -> !it.isCollectionLike()).filter(it -> !it.isMap()));
        this.getter = property.getGetter().orElse(null);
        this.setter = property.getSetter().orElse(null);
        this.field = property.getField().orElse(null);
    }

    protected abstract Association<P> createAssociation();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.information.getType();
    }

    @Override
    public Class<?> getRawType() {
        return this.rawType;
    }

    @Override
    public TypeInformation<?> getTypeInformation() {
        return this.information;
    }

    @Override
    @Deprecated
    public Iterable<? extends TypeInformation<?>> getPersistentEntityType() {
        if (!this.isEntity()) {
            return Collections.emptySet();
        }
        return this.entityTypeInformation.get().map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    @Override
    @Nullable
    public String getSpelExpression() {
        return null;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return !this.isTransient();
    }

    @Override
    public boolean isAssociation() {
        return this.isAnnotationPresent(Reference.class);
    }

    @Override
    @Nullable
    public Association<P> getAssociation() {
        return this.association.orElse(null);
    }

    @Override
    public boolean isCollectionLike() {
        return this.information.isCollectionLike();
    }

    @Override
    public boolean isMap() {
        return Map.class.isAssignableFrom(this.getType());
    }

    @Override
    public boolean isArray() {
        return this.getType().isArray();
    }

    @Override
    public boolean isEntity() {
        return !this.isTransient() && this.entityTypeInformation.get().isPresent();
    }

    @Override
    @Nullable
    public Class<?> getComponentType() {
        return this.isMap() || this.isCollectionLike() ? this.information.getRequiredComponentType().getType() : null;
    }

    @Override
    @Nullable
    public Class<?> getMapValueType() {
        TypeInformation<?> mapValueType;
        if (this.isMap() && (mapValueType = this.information.getMapValueType()) != null) {
            return mapValueType.getType();
        }
        return null;
    }

    @Override
    public Class<?> getActualType() {
        return this.information.getRequiredActualType().getType();
    }

    @Override
    public boolean usePropertyAccess() {
        return this.usePropertyAccess.get();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractPersistentProperty)) {
            return false;
        }
        AbstractPersistentProperty that = (AbstractPersistentProperty)obj;
        return this.property.equals(that.property);
    }

    public int hashCode() {
        return this.hashCode.get();
    }

    public String toString() {
        return this.property.toString();
    }

    @Override
    public PersistentEntity<?, P> getOwner() {
        return this.owner;
    }

    protected Property getProperty() {
        return this.property;
    }

    @Override
    @Nullable
    public Method getGetter() {
        return this.getter;
    }

    @Override
    @Nullable
    public Method getSetter() {
        return this.setter;
    }

    @Override
    @Nullable
    public Field getField() {
        return this.field;
    }
}

