/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.ReflectionEntityInstantiator;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.MappingInstantiationException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ClassGeneratingEntityInstantiator
implements EntityInstantiator {
    private final ObjectInstantiatorClassGenerator generator;
    private volatile Map<TypeInformation<?>, EntityInstantiator> entityInstantiators = new HashMap(32);

    public ClassGeneratingEntityInstantiator() {
        this.generator = new ObjectInstantiatorClassGenerator();
    }

    @Override
    public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
        EntityInstantiator instantiator = this.entityInstantiators.get(entity.getTypeInformation());
        if (instantiator == null) {
            instantiator = this.potentiallyCreateAndRegisterEntityInstantiator(entity);
        }
        return instantiator.createInstance(entity, provider);
    }

    private synchronized EntityInstantiator potentiallyCreateAndRegisterEntityInstantiator(PersistentEntity<?, ?> entity) {
        Map<TypeInformation<?>, EntityInstantiator> map = this.entityInstantiators;
        EntityInstantiator instantiator = map.get(entity.getTypeInformation());
        if (instantiator != null) {
            return instantiator;
        }
        instantiator = this.createEntityInstantiator(entity);
        map = new HashMap(map);
        map.put(entity.getTypeInformation(), instantiator);
        this.entityInstantiators = map;
        return instantiator;
    }

    private EntityInstantiator createEntityInstantiator(PersistentEntity<?, ?> entity) {
        if (this.shouldUseReflectionEntityInstantiator(entity)) {
            return ReflectionEntityInstantiator.INSTANCE;
        }
        try {
            return new EntityInstantiatorAdapter(this.createObjectInstantiator(entity));
        }
        catch (Throwable ex) {
            return ReflectionEntityInstantiator.INSTANCE;
        }
    }

    private boolean shouldUseReflectionEntityInstantiator(PersistentEntity<?, ?> entity) {
        Class<?> type = entity.getType();
        if (type.isInterface() || type.isArray() || !Modifier.isPublic(type.getModifiers()) || type.isMemberClass() && !Modifier.isStatic(type.getModifiers()) || ClassUtils.isCglibProxyClass(type)) {
            return true;
        }
        PreferredConstructor<?, ?> persistenceConstructor = entity.getPersistenceConstructor();
        return persistenceConstructor == null || !Modifier.isPublic(persistenceConstructor.getConstructor().getModifiers());
    }

    private ObjectInstantiator createObjectInstantiator(PersistentEntity<?, ?> entity) {
        try {
            return (ObjectInstantiator)this.generator.generateCustomInstantiatorClass(entity).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class ObjectInstantiatorClassGenerator {
        private static final String INIT = "<init>";
        private static final String TAG = "_Instantiator_";
        private static final String JAVA_LANG_OBJECT = "java/lang/Object";
        private static final String CREATE_METHOD_NAME = "newInstance";
        private static final String[] IMPLEMENTED_INTERFACES = new String[]{Type.getInternalName(ObjectInstantiator.class)};
        private final ByteArrayClassLoader classLoader = AccessController.doPrivileged(() -> new ByteArrayClassLoader(ClassUtils.getDefaultClassLoader()));

        private ObjectInstantiatorClassGenerator() {
        }

        public Class<?> generateCustomInstantiatorClass(PersistentEntity<?, ?> entity) {
            String className = this.generateClassName(entity);
            byte[] bytecode = this.generateBytecode(className, entity);
            return this.classLoader.loadClass(className, bytecode);
        }

        private String generateClassName(PersistentEntity<?, ?> entity) {
            return entity.getType().getName() + TAG + Integer.toString(entity.hashCode(), 36);
        }

        public byte[] generateBytecode(String internalClassName, PersistentEntity<?, ?> entity) {
            ClassWriter cw = new ClassWriter(1);
            cw.visit(50, 33, internalClassName.replace('.', '/'), null, JAVA_LANG_OBJECT, IMPLEMENTED_INTERFACES);
            this.visitDefaultConstructor(cw);
            this.visitCreateMethod(cw, entity);
            cw.visitEnd();
            return cw.toByteArray();
        }

        private void visitDefaultConstructor(ClassWriter cw) {
            MethodVisitor mv = cw.visitMethod(1, INIT, "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, JAVA_LANG_OBJECT, INIT, "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }

        private void visitCreateMethod(ClassWriter cw, PersistentEntity<?, ?> entity) {
            String entityTypeResourcePath = Type.getInternalName(entity.getType());
            MethodVisitor mv = cw.visitMethod(129, CREATE_METHOD_NAME, "([Ljava/lang/Object;)Ljava/lang/Object;", null, null);
            mv.visitCode();
            mv.visitTypeInsn(187, entityTypeResourcePath);
            mv.visitInsn(89);
            PreferredConstructor<?, ?> constructor = entity.getPersistenceConstructor();
            if (constructor != null) {
                Constructor<?> ctor = constructor.getConstructor();
                Class<?>[] parameterTypes = ctor.getParameterTypes();
                for (int i = 0; i < parameterTypes.length; ++i) {
                    mv.visitVarInsn(25, 1);
                    ObjectInstantiatorClassGenerator.visitArrayIndex(mv, i);
                    mv.visitInsn(50);
                    if (parameterTypes[i].isPrimitive()) {
                        ObjectInstantiatorClassGenerator.insertUnboxInsns(mv, Type.getType(parameterTypes[i]).toString().charAt(0), "");
                        continue;
                    }
                    mv.visitTypeInsn(192, Type.getInternalName(parameterTypes[i]));
                }
                mv.visitMethodInsn(183, entityTypeResourcePath, INIT, Type.getConstructorDescriptor(ctor), false);
                mv.visitInsn(176);
                mv.visitMaxs(0, 0);
                mv.visitEnd();
            }
        }

        private static void visitArrayIndex(MethodVisitor mv, int idx) {
            if (idx >= 0 && idx < 6) {
                mv.visitInsn(3 + idx);
                return;
            }
            mv.visitLdcInsn((Object)idx);
        }

        private static void insertUnboxInsns(MethodVisitor mv, char ch, String stackDescriptor) {
            switch (ch) {
                case 'Z': {
                    if (!stackDescriptor.equals("Ljava/lang/Boolean")) {
                        mv.visitTypeInsn(192, "java/lang/Boolean");
                    }
                    mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
                    break;
                }
                case 'B': {
                    if (!stackDescriptor.equals("Ljava/lang/Byte")) {
                        mv.visitTypeInsn(192, "java/lang/Byte");
                    }
                    mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
                    break;
                }
                case 'C': {
                    if (!stackDescriptor.equals("Ljava/lang/Character")) {
                        mv.visitTypeInsn(192, "java/lang/Character");
                    }
                    mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
                    break;
                }
                case 'D': {
                    if (!stackDescriptor.equals("Ljava/lang/Double")) {
                        mv.visitTypeInsn(192, "java/lang/Double");
                    }
                    mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
                    break;
                }
                case 'F': {
                    if (!stackDescriptor.equals("Ljava/lang/Float")) {
                        mv.visitTypeInsn(192, "java/lang/Float");
                    }
                    mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
                    break;
                }
                case 'I': {
                    if (!stackDescriptor.equals("Ljava/lang/Integer")) {
                        mv.visitTypeInsn(192, "java/lang/Integer");
                    }
                    mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
                    break;
                }
                case 'J': {
                    if (!stackDescriptor.equals("Ljava/lang/Long")) {
                        mv.visitTypeInsn(192, "java/lang/Long");
                    }
                    mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
                    break;
                }
                case 'S': {
                    if (!stackDescriptor.equals("Ljava/lang/Short")) {
                        mv.visitTypeInsn(192, "java/lang/Short");
                    }
                    mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unboxing should not be attempted for descriptor '" + ch + "'");
                }
            }
        }

        private class ByteArrayClassLoader
        extends ClassLoader {
            public ByteArrayClassLoader(ClassLoader parent) {
                super(parent);
            }

            public Class<?> loadClass(String name, byte[] bytes) {
                Assert.notNull((Object)name, (String)"name must not be null");
                Assert.notNull((Object)bytes, (String)"bytes must not be null");
                try {
                    Class<?> clazz = this.findClass(name);
                    if (clazz != null) {
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                return this.defineClass(name, bytes, 0, bytes.length);
            }
        }
    }

    public static interface ObjectInstantiator {
        public Object newInstance(Object ... var1);
    }

    private static class EntityInstantiatorAdapter
    implements EntityInstantiator {
        private static final Object[] EMPTY_ARRAY = new Object[0];
        private final ObjectInstantiator instantiator;

        public EntityInstantiatorAdapter(ObjectInstantiator instantiator) {
            this.instantiator = instantiator;
        }

        @Override
        public <T, E extends PersistentEntity<? extends T, P>, P extends PersistentProperty<P>> T createInstance(E entity, ParameterValueProvider<P> provider) {
            Object[] params = this.extractInvocationArguments(entity.getPersistenceConstructor(), provider);
            try {
                return (T)this.instantiator.newInstance(params);
            }
            catch (Exception e) {
                throw new MappingInstantiationException(entity, Arrays.asList(params), e);
            }
        }

        private <P extends PersistentProperty<P>, T> Object[] extractInvocationArguments(@Nullable PreferredConstructor<? extends T, P> constructor, ParameterValueProvider<P> provider) {
            if (provider == null || constructor == null || !constructor.hasParameters()) {
                return EMPTY_ARRAY;
            }
            ArrayList<Object> params = new ArrayList<Object>(constructor.getConstructor().getParameterCount());
            for (PreferredConstructor.Parameter<Object, P> parameter : constructor.getParameters()) {
                params.add(provider.getParameterValue(parameter));
            }
            return params.toArray();
        }
    }
}

