/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.List;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

public class PreferredConstructorDiscoverer<T, P extends PersistentProperty<P>> {
    private static final ParameterNameDiscoverer PARAMETER_DISCOVERER = new DefaultParameterNameDiscoverer();
    private PreferredConstructor<T, P> constructor;

    public PreferredConstructorDiscoverer(Class<T> type) {
        this(ClassTypeInformation.from(type), null);
    }

    public PreferredConstructorDiscoverer(PersistentEntity<T, P> entity) {
        this(entity.getTypeInformation(), entity);
    }

    protected PreferredConstructorDiscoverer(TypeInformation<T> type, PersistentEntity<T, P> entity) {
        boolean noArgConstructorFound = false;
        int numberOfArgConstructors = 0;
        Class<T> rawOwningType = type.getType();
        for (Constructor<?> constructor : rawOwningType.getDeclaredConstructors()) {
            PreferredConstructor<T, P> preferredConstructor = this.buildPreferredConstructor(constructor, type, entity);
            if (preferredConstructor.isExplicitlyAnnotated()) {
                this.constructor = preferredConstructor;
                return;
            }
            if (this.constructor == null || preferredConstructor.isNoArgConstructor()) {
                this.constructor = preferredConstructor;
            }
            if (preferredConstructor.isNoArgConstructor()) {
                noArgConstructorFound = true;
                continue;
            }
            ++numberOfArgConstructors;
        }
        if (!noArgConstructorFound && numberOfArgConstructors > 1) {
            this.constructor = null;
        }
    }

    private PreferredConstructor<T, P> buildPreferredConstructor(Constructor<?> constructor, TypeInformation<T> typeInformation, PersistentEntity<T, P> entity) {
        List<TypeInformation<?>> parameterTypes = typeInformation.getParameterTypes(constructor);
        if (parameterTypes.isEmpty()) {
            return new PreferredConstructor(constructor, new PreferredConstructor.Parameter[0]);
        }
        String[] parameterNames = PARAMETER_DISCOVERER.getParameterNames(constructor);
        PreferredConstructor.Parameter[] parameters = new PreferredConstructor.Parameter[parameterTypes.size()];
        Annotation[][] parameterAnnotations = constructor.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String name = parameterNames == null ? null : parameterNames[i];
            TypeInformation<?> type = parameterTypes.get(i);
            Annotation[] annotations = parameterAnnotations[i];
            parameters[i] = new PreferredConstructor.Parameter(name, type, annotations, entity);
        }
        return new PreferredConstructor(constructor, parameters);
    }

    public PreferredConstructor<T, P> getConstructor() {
        return this.constructor;
    }
}

