/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class DefaultPersistentPropertyPath<T extends PersistentProperty<T>>
implements PersistentPropertyPath<T> {
    private final List<T> properties;

    public DefaultPersistentPropertyPath(List<T> properties) {
        Assert.notNull(properties);
        Assert.isTrue((!properties.isEmpty() ? 1 : 0) != 0);
        this.properties = properties;
    }

    @Override
    public String toDotPath() {
        return this.toPath(null, null);
    }

    @Override
    public String toDotPath(Converter<? super T, String> converter) {
        return this.toPath(null, converter);
    }

    @Override
    public String toPath(String delimiter) {
        return this.toPath(delimiter, null);
    }

    @Override
    public String toPath(String delimiter, Converter<? super T, String> converter) {
        Converter<? super T, String> converterToUse = converter == null ? PropertyNameConverter.INSTANCE : converter;
        String delimiterToUse = delimiter == null ? "." : delimiter;
        ArrayList<String> result = new ArrayList<String>();
        for (PersistentProperty property : this.properties) {
            String convert = (String)converterToUse.convert((Object)property);
            if (!StringUtils.hasText((String)convert)) continue;
            result.add(convert);
        }
        return result.isEmpty() ? null : StringUtils.collectionToDelimitedString(result, (String)delimiterToUse);
    }

    @Override
    public T getLeafProperty() {
        return (T)((PersistentProperty)this.properties.get(this.properties.size() - 1));
    }

    @Override
    public T getBaseProperty() {
        return (T)((PersistentProperty)this.properties.get(0));
    }

    @Override
    public boolean isBasePathOf(PersistentPropertyPath<T> path) {
        if (path == null) {
            return false;
        }
        Iterator iterator = path.iterator();
        for (PersistentProperty property : this) {
            if (!iterator.hasNext()) {
                return false;
            }
            PersistentProperty reference = (PersistentProperty)iterator.next();
            if (property.equals(reference)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PersistentPropertyPath<T> getExtensionForBaseOf(PersistentPropertyPath<T> base) {
        if (!base.isBasePathOf(this)) {
            return this;
        }
        ArrayList<T> properties = new ArrayList<T>();
        Iterator<T> iterator = this.iterator();
        for (int i = 0; i < base.getLength(); ++i) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            properties.add(iterator.next());
        }
        return new DefaultPersistentPropertyPath(properties);
    }

    @Override
    public PersistentPropertyPath<T> getParentPath() {
        int size = this.properties.size();
        if (size <= 1) {
            return this;
        }
        return new DefaultPersistentPropertyPath<T>(this.properties.subList(0, size - 1));
    }

    @Override
    public int getLength() {
        return this.properties.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.properties.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DefaultPersistentPropertyPath that = (DefaultPersistentPropertyPath)obj;
        return ((Object)this.properties).equals(that.properties);
    }

    public int hashCode() {
        return ((Object)this.properties).hashCode();
    }

    public String toString() {
        return this.toDotPath();
    }

    private static enum PropertyNameConverter implements Converter<PersistentProperty<?>, String>
    {
        INSTANCE;


        public String convert(PersistentProperty<?> source) {
            return source.getName();
        }
    }
}

