/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class DefaultRepositoryConfiguration<T extends RepositoryConfigurationSource>
implements RepositoryConfiguration<T> {
    private static final QueryLookupStrategy.Key DEFAULT_QUERY_LOOKUP_STRATEGY = QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;
    private static final String DEFAULT_REPOSITORY_IMPLEMENTATION_POSTFIX = "Impl";
    private final T configurationSource;
    private final String interfaceName;

    public DefaultRepositoryConfiguration(T configurationSource, String interfaceName) {
        Assert.notNull(configurationSource);
        Assert.hasText((String)interfaceName);
        this.configurationSource = configurationSource;
        this.interfaceName = interfaceName;
    }

    @Override
    public String getBeanId() {
        return StringUtils.uncapitalize((String)ClassUtils.getShortName((String)this.interfaceName));
    }

    @Override
    public Object getQueryLookupStrategyKey() {
        Object configuredStrategy = this.configurationSource.getQueryLookupStrategyKey();
        return configuredStrategy != null ? configuredStrategy : DEFAULT_QUERY_LOOKUP_STRATEGY;
    }

    @Override
    public Iterable<String> getBasePackages() {
        return this.configurationSource.getBasePackages();
    }

    @Override
    public String getRepositoryInterface() {
        return this.interfaceName;
    }

    public RepositoryConfigurationSource getConfigSource() {
        return this.configurationSource;
    }

    @Override
    public String getNamedQueriesLocation() {
        return this.configurationSource.getNamedQueryLocation();
    }

    @Override
    public String getImplementationClassName() {
        return ClassUtils.getShortName((String)this.interfaceName) + this.getImplementationPostfix();
    }

    @Override
    public String getImplementationBeanName() {
        return StringUtils.uncapitalize((String)this.getImplementationClassName());
    }

    public String getImplementationPostfix() {
        String configuredPostfix = this.configurationSource.getRepositoryImplementationPostfix();
        return StringUtils.hasText((String)configuredPostfix) ? configuredPostfix : DEFAULT_REPOSITORY_IMPLEMENTATION_POSTFIX;
    }

    @Override
    public Object getSource() {
        return this.configurationSource.getSource();
    }

    @Override
    public T getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public String getRepositoryFactoryBeanName() {
        return this.configurationSource.getRepositoryFactoryBeanName();
    }
}

