/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.projection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class MapAccessingMethodInterceptor
implements MethodInterceptor {
    private final Map<String, Object> map;

    public MapAccessingMethodInterceptor(Map<String, Object> map) {
        Assert.notNull(map, (String)"Map must not be null!");
        this.map = map;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (ReflectionUtils.isObjectMethod((Method)method)) {
            return invocation.proceed();
        }
        Accessor accessor = new Accessor(method);
        if (accessor.isGetter()) {
            return this.map.get(accessor.getPropertyName());
        }
        if (accessor.isSetter()) {
            this.map.put(accessor.getPropertyName(), invocation.getArguments()[0]);
            return null;
        }
        throw new IllegalStateException("Should never get here!");
    }

    private static final class Accessor {
        private final PropertyDescriptor descriptor;
        private final Method method;

        public Accessor(Method method) {
            Assert.notNull((Object)method, (String)"Method must not be null!");
            this.descriptor = BeanUtils.findPropertyForMethod((Method)method);
            this.method = method;
            Assert.notNull((Object)this.descriptor, (String)String.format("Invoked method %s is no accessor method!", method));
        }

        public boolean isGetter() {
            return this.method.equals(this.descriptor.getReadMethod());
        }

        public boolean isSetter() {
            return this.method.equals(this.descriptor.getWriteMethod());
        }

        public String getPropertyName() {
            return this.descriptor.getName();
        }
    }
}

