/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.DefaultRepositoryInvokerFactory;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.repository.support.RepositoryInvokerFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DomainClassConverter<T extends ConversionService & ConverterRegistry>
implements ConditionalGenericConverter,
ApplicationContextAware {
    private final T conversionService;
    private Repositories repositories = Repositories.NONE;
    private ToEntityConverter toEntityConverter;
    private ToIdConverter toIdConverter;

    public DomainClassConverter(T conversionService) {
        Assert.notNull(conversionService, (String)"ConversionService must not be null!");
        this.conversionService = conversionService;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.repositories.hasRepositoryFor(targetType.getType()) ? this.toEntityConverter.convert(source, sourceType, targetType) : this.toIdConverter.convert(source, sourceType, targetType);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.toEntityConverter.matches(sourceType, targetType) || this.toIdConverter.matches(sourceType, targetType);
        }
        catch (ConversionMatchAbbreviationException o_O) {
            return false;
        }
    }

    public void setApplicationContext(ApplicationContext context) {
        this.repositories = new Repositories((ListableBeanFactory)context);
        this.toEntityConverter = new ToEntityConverter(this.repositories, (ConversionService)this.conversionService);
        ((ConverterRegistry)this.conversionService).addConverter((GenericConverter)this.toEntityConverter);
        this.toIdConverter = new ToIdConverter();
        ((ConverterRegistry)this.conversionService).addConverter((GenericConverter)this.toIdConverter);
    }

    private static final class ConversionMatchAbbreviationException
    extends RuntimeException {
        private ConversionMatchAbbreviationException() {
        }
    }

    private class ToIdConverter
    implements ConditionalGenericConverter {
        private ToIdConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null || !StringUtils.hasText((String)source.toString())) {
                return null;
            }
            if (sourceType.equals((Object)targetType)) {
                return source;
            }
            Class domainType = sourceType.getType();
            EntityInformation entityInformation = DomainClassConverter.this.repositories.getEntityInformationFor(domainType);
            return DomainClassConverter.this.conversionService.convert(entityInformation.getId(source), targetType.getType());
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!DomainClassConverter.this.repositories.hasRepositoryFor(sourceType.getType())) {
                return false;
            }
            if (sourceType.equals((Object)targetType)) {
                return true;
            }
            Class<? extends Serializable> rawIdType = DomainClassConverter.this.repositories.getRepositoryInformationFor(sourceType.getType()).getIdType();
            return targetType.equals((Object)TypeDescriptor.valueOf(rawIdType)) || DomainClassConverter.this.conversionService.canConvert(rawIdType, targetType.getType());
        }
    }

    private class ToEntityConverter
    implements ConditionalGenericConverter {
        private final RepositoryInvokerFactory repositoryInvokerFactory;

        public ToEntityConverter(Repositories repositories, ConversionService conversionService) {
            this.repositoryInvokerFactory = new DefaultRepositoryInvokerFactory(repositories, conversionService);
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(new GenericConverter.ConvertiblePair(Object.class, Object.class));
        }

        public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null || !StringUtils.hasText((String)source.toString())) {
                return null;
            }
            if (sourceType.equals((Object)targetType)) {
                return source;
            }
            Class domainType = targetType.getType();
            RepositoryInformation info = DomainClassConverter.this.repositories.getRepositoryInformationFor(domainType);
            RepositoryInvoker invoker = this.repositoryInvokerFactory.getInvokerFor(domainType);
            return invoker.invokeFindOne((Serializable)DomainClassConverter.this.conversionService.convert(source, info.getIdType()));
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (!DomainClassConverter.this.repositories.hasRepositoryFor(targetType.getType())) {
                return false;
            }
            if (sourceType.equals((Object)targetType)) {
                return true;
            }
            Class<? extends Serializable> rawIdType = DomainClassConverter.this.repositories.getRepositoryInformationFor(targetType.getType()).getIdType();
            if (sourceType.equals((Object)TypeDescriptor.valueOf(rawIdType)) || DomainClassConverter.this.conversionService.canConvert(sourceType.getType(), rawIdType)) {
                return true;
            }
            throw new ConversionMatchAbbreviationException();
        }
    }
}

