/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.TargetSource;
import org.springframework.data.cassandra.observability.CassandraObservationContext;
import org.springframework.data.cassandra.observability.CassandraObservationConvention;
import org.springframework.data.cassandra.observability.ObservationStatement;

final class CqlSessionObservationInterceptor
implements MethodInterceptor {
    private final CqlSession delegate;
    private final String remoteServiceName;
    private final ObservationRegistry observationRegistry;
    private final CassandraObservationConvention convention;

    CqlSessionObservationInterceptor(CqlSession delegate, String remoteServiceName, CassandraObservationConvention convention, ObservationRegistry observationRegistry) {
        this.delegate = delegate;
        this.remoteServiceName = remoteServiceName;
        this.convention = convention;
        this.observationRegistry = observationRegistry;
    }

    public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Object[] args = invocation.getArguments();
        if (method.getName().equals("getTargetClass")) {
            return this.delegate.getClass();
        }
        if (method.getName().equals("execute") && args.length > 0) {
            return this.observe(CqlSessionObservationInterceptor.createStatement(args), method.getName(), arg_0 -> ((CqlSession)this.delegate).execute(arg_0));
        }
        if (method.getName().equals("executeAsync") && args.length > 0) {
            return this.observe(CqlSessionObservationInterceptor.createStatement(args), method.getName(), arg_0 -> ((CqlSession)this.delegate).executeAsync(arg_0));
        }
        if (method.getName().equals("prepare") && args.length > 0) {
            Statement<?> statement = CqlSessionObservationInterceptor.createStatement(args);
            if (ObservationStatement.isObservationStatement(statement)) {
                return this.delegate.prepareAsync((SimpleStatement)statement);
            }
            Observation observation = this.startObservation(statement, true, "prepare");
            try {
                PreparedStatement preparedStatement2 = this.delegate.prepare((SimpleStatement)statement);
                return preparedStatement2;
            }
            catch (RuntimeException e) {
                observation.error((Throwable)e);
                throw e;
            }
            finally {
                observation.stop();
            }
        }
        if (method.getName().equals("prepareAsync") && args.length > 0) {
            Statement<?> statement = CqlSessionObservationInterceptor.createStatement(args);
            if (ObservationStatement.isObservationStatement(statement)) {
                return this.delegate.prepareAsync((SimpleStatement)statement);
            }
            Observation observation = this.startObservation(statement, true, "prepareAsync");
            return this.delegate.prepareAsync((SimpleStatement)statement).whenComplete((preparedStatement, throwable) -> {
                if (throwable != null) {
                    observation.error(throwable);
                }
                observation.stop();
            });
        }
        return invocation.proceed();
    }

    private static Statement<?> createStatement(Object[] args) {
        if (args[0] instanceof Statement) {
            return (Statement)args[0];
        }
        if (args[0] instanceof String & args.length == 1) {
            return SimpleStatement.newInstance((String)((String)args[0]));
        }
        Object object = args[0];
        if (object instanceof String) {
            String query2 = (String)object;
            if (args.length == 2) {
                return args[1] instanceof Map ? SimpleStatement.newInstance((String)query2, (Map)((Map)args[1])) : SimpleStatement.newInstance((String)query2, (Object[])((Object[])args[1]));
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported arguments %s", Arrays.toString(args)));
    }

    private Object observe(Statement<?> statement, String methodName, Function<Statement<?>, Object> statementExecutor) {
        if (ObservationStatement.isObservationStatement(statement)) {
            return statementExecutor.apply(statement);
        }
        Statement<?> observableStatement = ObservationStatement.createProxy(this.startObservation(statement, false, methodName), statement);
        return statementExecutor.apply(observableStatement);
    }

    private Observation startObservation(Statement<?> statement, boolean prepare, String methodName) {
        Observation currentObservation = this.observationRegistry.getCurrentObservation();
        Observation observation = Observation.createNotStarted((String)methodName, () -> new CassandraObservationContext(statement, this.remoteServiceName, prepare, methodName, this.delegate.getContext().getSessionName(), this.delegate.getKeyspace().map(CqlIdentifier::asInternal).orElse("system")), (ObservationRegistry)this.observationRegistry).observationConvention((ObservationConvention)this.convention);
        if (currentObservation != null) {
            observation.parentObservation(currentObservation);
        }
        return observation.start();
    }

    public static interface ObservationDecoratedProxy
    extends TargetSource {
    }
}

