/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.converter;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.cql.converter.ResultSetToListConverter;

public abstract class AbstractResultSetConverter<T>
implements Converter<ResultSet, T> {
    private static final ResultSetToListConverter converter = new ResultSetToListConverter();

    protected abstract @Nullable T doConvertSingleValue(Object var1);

    protected abstract Class<?> getType();

    protected @Nullable T getNullResultSetValue() {
        return null;
    }

    protected @Nullable T getExhaustedResultSetValue() {
        return null;
    }

    public @Nullable T convert(ResultSet source) {
        if (source.getAvailableWithoutFetching() == 0 && source.isFullyFetched()) {
            return this.getExhaustedResultSetValue();
        }
        List<@Nullable Map<String, Object>> list = converter.convert(source);
        if (list.size() == 1) {
            Map<String, Object> map = list.get(0);
            return map != null ? (map.size() == 1 ? this.doConvertSingleValue(map.get(map.keySet().iterator().next())) : this.doConvertSingleRow(map)) : this.getNullResultSetValue();
        }
        return this.doConvertResultSet(list);
    }

    protected T doConvertResultSet(List<@Nullable Map<String, Object>> resultSet) {
        throw new IllegalArgumentException(String.format("Cannot convert %s to desired type [%s]", "result set", this.getType().getName()));
    }

    protected T doConvertSingleRow(Map<String, Object> row) {
        throw new IllegalArgumentException(String.format("Cannot convert %s to desired type [%s]", "row", this.getType().getName()));
    }
}

