/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.core.ReactiveWrappers;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;

public class CassandraParameters
extends Parameters<CassandraParameters, CassandraParameter> {
    private final @Nullable Integer queryOptionsIndex;
    private final @Nullable Integer scoringFunctionIndex;

    public CassandraParameters(ParametersSource parametersSource) {
        super(parametersSource, methodParameter -> new CassandraParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
        this.queryOptionsIndex = Arrays.asList(parametersSource.getMethod().getParameterTypes()).indexOf(QueryOptions.class);
        this.scoringFunctionIndex = Arrays.asList(parametersSource.getMethod().getParameterTypes()).indexOf(ScoringFunction.class);
    }

    private CassandraParameters(List<CassandraParameter> originals, @Nullable Integer queryOptionsIndex, @Nullable Integer scoringFunctionIndex) {
        super(originals);
        this.queryOptionsIndex = queryOptionsIndex;
        this.scoringFunctionIndex = scoringFunctionIndex;
    }

    protected CassandraParameters createFrom(List<CassandraParameter> parameters) {
        return new CassandraParameters(parameters, this.queryOptionsIndex, this.scoringFunctionIndex);
    }

    public int getQueryOptionsIndex() {
        return this.queryOptionsIndex != null ? this.queryOptionsIndex : -1;
    }

    public int getScoringFunctionIndex() {
        return this.scoringFunctionIndex != null ? this.scoringFunctionIndex : -1;
    }

    public static class CassandraParameter
    extends Parameter {
        private final @Nullable CassandraType cassandraType;
        private final Class<?> parameterType;
        private final boolean isScoreRange;
        private final boolean isScoringFunction;

        CassandraParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
            AnnotatedParameter annotatedParameter = new AnnotatedParameter(parameter);
            this.cassandraType = AnnotatedElementUtils.hasAnnotation((AnnotatedElement)annotatedParameter, CassandraType.class) ? (CassandraType)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedParameter, CassandraType.class) : null;
            this.parameterType = CassandraParameter.potentiallyUnwrapParameterType(parameter);
            ResolvableType type = ResolvableType.forMethodParameter((MethodParameter)parameter);
            this.isScoreRange = Range.class.isAssignableFrom(this.getType()) && type.getGeneric(new int[]{0}).isAssignableFrom(Score.class);
            this.isScoringFunction = ScoringFunction.class.isAssignableFrom(this.getType());
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || this.isScoreRange || this.isScoringFunction || Score.class.isAssignableFrom(this.getType()) || QueryOptions.class.isAssignableFrom(this.getType());
        }

        public @Nullable CassandraType getCassandraType() {
            return this.cassandraType;
        }

        public Class<?> getType() {
            return this.parameterType;
        }

        private static Class<?> potentiallyUnwrapParameterType(MethodParameter parameter) {
            Class originalType = parameter.getParameterType();
            if (CassandraParameter.isWrapped(parameter) && CassandraParameter.shouldUnwrap(parameter)) {
                Class rawClass = ResolvableType.forMethodParameter((MethodParameter)parameter).getGeneric(new int[]{0}).getRawClass();
                return rawClass == null ? Object.class : rawClass;
            }
            return originalType;
        }

        private static boolean isWrapped(MethodParameter parameter) {
            return QueryExecutionConverters.supports((Class)parameter.getParameterType()) || ReactiveWrapperConverters.supports((Class)parameter.getParameterType());
        }

        private static boolean shouldUnwrap(MethodParameter parameter) {
            return QueryExecutionConverters.supportsUnwrapping((Class)parameter.getParameterType()) || ReactiveWrappers.supports((Class)parameter.getParameterType());
        }
    }

    static class AnnotatedParameter
    implements AnnotatedElement {
        private final MethodParameter methodParameter;

        AnnotatedParameter(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        public <T extends Annotation> @Nullable T getAnnotation(Class<T> annotationClass) {
            return (T)this.methodParameter.getParameterAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.methodParameter.getParameterAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.methodParameter.getParameterAnnotations();
        }
    }
}

